/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph.rules;

import io.intino.tara.lang.model.rules.variable.VariableRule;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;

public enum TimeScale implements VariableRule<Enum>
{
    Year(ChronoUnit.YEARS){

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(LocalDateTime.of(this.yearOf(instant), 1, 1, 0, 0, 0));
        }

        @Override
        public long toMillis(long l) {
            return Day.toMillis((long)((double)l * 365.25));
        }

        @Override
        public String symbol(String string) {
            return string.equals("es") ? "A" : "Y";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            return String.valueOf(this.yearOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            return this.yearOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return String.valueOf(this.yearOf(instant));
        }
    }
    ,
    QuarterOfYear(ChronoUnit.MONTHS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("MM/yyyy");

        @Override
        public long instantsBetween(Instant instant, Instant instant2) {
            return Math.max(ChronoUnit.MONTHS.between(this.dateTimeOf(instant), this.dateTimeOf(instant2)) / 3L, 1L);
        }

        @Override
        public Instant addTo(Instant instant, long l) {
            return this.instantOf(ChronoUnit.MONTHS.addTo(this.dateTimeOf(instant), 3L * l));
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withMonth(this.firstMonthOfQuarter(instant)).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long l) {
            return Month.toMillis(l * 3L);
        }

        @Override
        public String symbol(String string) {
            return string.equals("es") ? "C" : "Q";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            int n = this.quarterNumber(instant);
            String string2 = translator.translate("TemporalCategorization.Category.Quarter" + n);
            if (string.equalsIgnoreCase("QuarterOfYear")) {
                string2 = string2 + " " + this.yearOf(instant);
            }
            return string2;
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            return this.quarterNumber(instant);
        }

        @Override
        public String toString(Instant instant) {
            return "Q" + this.quarterNumber(instant) + " (" + this.range(instant) + ")";
        }

        private String range(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant)) + " - " + this.Formatter.format(this.dateTimeOf(this.nextTime(instant)));
        }

        private int quarterNumber(Instant instant) {
            return (this.monthNumberOf(instant) - 1) / 3 + 1;
        }

        private int firstMonthOfQuarter(Instant instant) {
            return (this.monthNumberOf(instant) - 1) / 3 * 3 + 1;
        }
    }
    ,
    Month(ChronoUnit.MONTHS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("MM/yyyy");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long l) {
            return Day.toMillis(l * 30L);
        }

        @Override
        public String symbol(String string) {
            return "M";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            int n = this.dateTimeOf(instant).getMonthValue();
            String string2 = translator.translate("TemporalCategorization.Category.Month" + n);
            if (string.equalsIgnoreCase("MonthOfYear")) {
                string2 = string2 + " " + this.yearOf(instant);
            }
            return string2;
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            return this.dateTimeOf(instant).getMonthValue();
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    Week(ChronoUnit.WEEKS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).with(WeekFields.ISO.dayOfWeek(), 1L).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long l) {
            return Day.toMillis(l * 7L);
        }

        @Override
        public String symbol(String string) {
            return string.equals("es") ? "S" : "W";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            LocalDateTime localDateTime = this.dateTimeOf(instant);
            int n = localDateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
            String string2 = translator.translate("TemporalCategorization.Category.Week") + " " + TimeScale.format(n, 2);
            if (string.equalsIgnoreCase("WeekOfYear")) {
                string2 = string2 + " " + this.yearOf(instant);
            }
            return string2;
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            LocalDateTime localDateTime = this.dateTimeOf(instant);
            return localDateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
        }

        @Override
        public String toString(Instant instant) {
            LocalDateTime localDateTime = this.dateTimeOf(instant);
            return "Week " + TimeScale.format(localDateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR), 2) + " (" + this.range(instant) + ")";
        }

        private String range(Instant instant) {
            LocalDateTime localDateTime = this.dateTimeOf(instant);
            return this.Formatter.format(localDateTime) + " - " + this.Formatter.format(this.dateTimeOf(this.nextTime(instant)));
        }
    }
    ,
    Day(ChronoUnit.DAYS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long l) {
            return SixHours.toMillis(l * 4L);
        }

        @Override
        public String symbol(String string) {
            return "D";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            LocalDateTime localDateTime = this.dateTimeOf(instant);
            if (string.equalsIgnoreCase("DayOfYear")) {
                return translator.translate("TemporalCategorization.Category.Day") + " " + localDateTime.getDayOfYear();
            }
            if (string.equalsIgnoreCase("DayOfMonth")) {
                return translator.translate("TemporalCategorization.Category.Day") + " " + localDateTime.getDayOfMonth();
            }
            return translator.translate("TemporalCategorization.Category.Day" + localDateTime.getDayOfWeek().ordinal());
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            if (string.equalsIgnoreCase("DayOfYear")) {
                return this.dateTimeOf(instant).getDayOfYear();
            }
            if (string.equalsIgnoreCase("DayOfMonth")) {
                return this.dateTimeOf(instant).getDayOfMonth();
            }
            return this.dateTimeOf(instant).getDayOfWeek().ordinal();
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    SixHours(ChronoUnit.HOURS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public long instantsBetween(Instant instant, Instant instant2) {
            return Math.max(ChronoUnit.HOURS.between(instant, instant2) / 5L, 1L);
        }

        @Override
        public Instant addTo(Instant instant, long l) {
            return this.instantOf(ChronoUnit.HOURS.addTo(this.dateTimeOf(instant), 6L * l));
        }

        private int quarter(int n) {
            return n / 6 * 6;
        }

        @Override
        public Instant normalise(Instant instant) {
            LocalDateTime localDateTime = this.dateTimeOf(instant);
            return this.instantOf(localDateTime.withHour(this.quarter(localDateTime.getHour())).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long l) {
            return Hour.toMillis(l * 6L);
        }

        @Override
        public String symbol(String string) {
            return "6h";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            int n = this.hourOf(this.addTo(instant, -1L));
            return TimeScale.format(n, 2) + " - " + TimeScale.format(this.hourOf(instant), 2);
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            return this.hourOf(this.addTo(instant, -1L));
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(this.addTo(instant, -1L))) + " (" + TimeScale.format(this.hourOf(this.addTo(instant, -1L)), 2) + " - " + TimeScale.format(this.hourOf(instant), 2) + ")";
        }
    }
    ,
    Hour(ChronoUnit.HOURS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("HH");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long l) {
            return FifteenMinutes.toMillis(l * 4L);
        }

        @Override
        public String symbol(String string) {
            return "h";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            return this.hourOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    FifteenMinutes(ChronoUnit.MINUTES){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH");

        @Override
        public Instant normalise(Instant instant) {
            LocalDateTime localDateTime = this.dateTimeOf(instant);
            return this.instantOf(localDateTime.withMinute(this.quarter(localDateTime.getMinute())).withSecond(0).withNano(0));
        }

        @Override
        public long instantsBetween(Instant instant, Instant instant2) {
            return Math.max(ChronoUnit.MINUTES.between(instant, instant2) / 14L, 1L);
        }

        @Override
        public Instant addTo(Instant instant, long l) {
            return this.instantOf(ChronoUnit.MINUTES.addTo(this.dateTimeOf(instant), 15L * l));
        }

        @Override
        public long toMillis(long l) {
            return Minute.toMillis(l * 15L);
        }

        @Override
        public String symbol(String string) {
            return "15'";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            int n = this.minuteOf(this.addTo(instant, -1L));
            return TimeScale.format(n, 2) + " - " + TimeScale.format(this.minuteOf(instant), 2);
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            return this.minuteOf(this.addTo(instant, -1L));
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(this.addTo(instant, -1L))) + " (" + TimeScale.format(this.minuteOf(this.addTo(instant, -1L)), 2) + " - " + TimeScale.format(this.minuteOf(instant), 2) + ")";
        }

        private int quarter(int n) {
            return n / 15 * 15;
        }
    }
    ,
    Minute(ChronoUnit.MINUTES){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("mm");

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long l) {
            return Second.toMillis(l * 60L);
        }

        @Override
        public String symbol(String string) {
            return "m";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            return this.minuteOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    Second(ChronoUnit.SECONDS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("ss");

        @Override
        public Instant normalise(Instant instant) {
            return instant;
        }

        @Override
        public long toMillis(long l) {
            return l * 1000L;
        }

        @Override
        public String symbol(String string) {
            return "s";
        }

        @Override
        public String category(Instant instant, String string, Translator translator) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String string) {
            return this.secondOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    };

    private final ChronoUnit unit;
    private String label;

    private TimeScale(ChronoUnit chronoUnit) {
        this(chronoUnit, "");
    }

    private TimeScale(ChronoUnit chronoUnit, String string2) {
        this.unit = chronoUnit;
        this.label = string2;
    }

    private static String format(int n, int n2) {
        return String.format("%0" + n2 + "d", n);
    }

    public String label() {
        return this.label;
    }

    public void label(String string) {
        this.label = string;
    }

    public abstract Instant normalise(Instant var1);

    public abstract String toString(Instant var1);

    public Instant nextTime(Instant instant) {
        return this.addTo(instant, 1L);
    }

    public long instantsBetween(Instant instant, Instant instant2) {
        return Math.max(this.unit.between(this.dateTimeOf(instant), this.unit.addTo(this.dateTimeOf(instant2), 1L)), 1L);
    }

    public abstract long toMillis(long var1);

    public Instant addTo(Instant instant, long l) {
        return this.instantOf(this.unit.addTo(this.dateTimeOf(instant), l));
    }

    public Instant floor(Instant instant) {
        return instant.truncatedTo(this.unit);
    }

    public boolean accept(Enum enum_) {
        return enum_ instanceof TimeScale;
    }

    public abstract String symbol(String var1);

    public abstract String category(Instant var1, String var2, Translator var3);

    public abstract int sortingWeight(Instant var1, String var2);

    public TimeScale next() {
        int n = this.ordinal();
        if (++n > ChronoUnit.SECONDS.ordinal()) {
            return Second;
        }
        return TimeScale.values()[n];
    }

    protected int yearOf(Instant instant) {
        return this.dateTimeOf(instant).getYear();
    }

    protected Month monthOf(Instant instant) {
        return this.dateTimeOf(instant).getMonth();
    }

    protected int monthNumberOf(Instant instant) {
        return this.dateTimeOf(instant).getMonthValue();
    }

    protected int dayOfYearOf(Instant instant) {
        return this.dateTimeOf(instant).getDayOfYear();
    }

    protected int dayOfMonthOf(Instant instant) {
        return this.dateTimeOf(instant).getDayOfMonth();
    }

    protected int hourOf(Instant instant) {
        return this.dateTimeOf(instant).getHour();
    }

    protected int minuteOf(Instant instant) {
        return this.dateTimeOf(instant).getMinute();
    }

    protected int secondOf(Instant instant) {
        return this.dateTimeOf(instant).getSecond();
    }

    protected ZoneId utc() {
        return ZoneId.of("UTC");
    }

    protected ZoneOffset utcOffset() {
        return ZoneOffset.UTC;
    }

    protected Instant instantOf(LocalDateTime localDateTime) {
        return localDateTime.toInstant(this.utcOffset());
    }

    LocalDateTime dateTimeOf(Instant instant) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(instant.toEpochMilli()), this.utc());
    }

    public static interface Translator {
        public String translate(String var1);
    }
}

