/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.collection;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.UserHelper;
import io.quassar.editor.model.License;
import io.quassar.editor.model.User;
import java.time.Instant;

public class RenewLicenseCommand
extends Command<RenewResult> {
    public License license;
    public int duration;

    public RenewLicenseCommand(EditorBox box) {
        super(box);
    }

    @Override
    public RenewResult execute() {
        if (!PermissionsHelper.hasCredit(this.duration, this.author, this.box)) {
            return new RenewResult(false, "You don't have enough credit to renew this license", null);
        }
        if (this.license.status() == License.Status.Revoked) {
            return new RenewResult(false, "This license have been revoked. Contact collection owner", null);
        }
        if (this.license.status() != License.Status.Assigned) {
            return new RenewResult(false, "This license is not assigned yet", null);
        }
        this.license.assignDate(Instant.now());
        this.license.duration(this.duration);
        User user = UserHelper.user(this.author, this.box);
        int licenseTime = UserHelper.licenseTime(this.author, this.box);
        user.licenseTime(licenseTime - this.duration);
        return new RenewResult(true, null, this.license);
    }

    public record RenewResult(boolean success, String message, License license) {
    }
}

