/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.model;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.ShortIdGenerator;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

public class CreateModelCommand
extends Command<Model> {
    public String name;
    public String description;
    public GavCoordinates language;
    public Model.Usage usage = Model.Usage.EndUser;
    public String mainContent = null;
    public String owner;

    public CreateModelCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Model execute() {
        Model template;
        Model model = this.box.modelManager().create(ShortIdGenerator.generate(), this.name, this.description, this.language, this.usage, this.owner);
        Language language = this.box.languageManager().get(this.language);
        LanguageRelease release = language.release(this.language.version());
        if (this.usage == Model.Usage.Template) {
            release.template(model.id());
        }
        Model model2 = template = release.template() != null ? this.box.modelManager().get(release.template()) : null;
        if (template != null && this.box.modelManager().hasWorkspaceMograms(template, release.version())) {
            this.box.modelManager().copyWorkSpace(template, model);
        } else {
            this.createDefaultWorkspace(model);
        }
        return model;
    }

    private void createDefaultWorkspace(Model model) {
        ByteArrayInputStream content = this.mainContent != null ? new ByteArrayInputStream(this.mainContent.getBytes(StandardCharsets.UTF_8)) : null;
        this.box.modelManager().createFile(model, ModelHelper.validWorkspaceFileName("main.tara"), content, null);
    }
}

