/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.actions.QuassarAction;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.commands.UserCommands;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.User;

public class CreateMetamodelFromTemplateAction
extends QuassarAction {
    public String template;
    public String owner;

    public String execute() {
        Logger.info((String)"Creating metamodel for user %s".formatted(this.owner));
        this.createUserIfNotExists();
        Model metamodel = this.createMetamodel();
        this.copyTemplateWorkspaceTo(metamodel);
        Logger.info((String)"Metamodel created for %s with id %s".formatted(this.owner, metamodel.id()));
        return metamodel.id();
    }

    private void createUserIfNotExists() {
        User user = this.box.userManager().get(this.owner);
        if (user != null) {
            return;
        }
        this.box.commands(UserCommands.class).create(this.owner, this.owner, "quassar");
    }

    private Model createMetamodel() {
        String name = ModelHelper.proposeName();
        Language language = this.box.languageManager().getMetta();
        LanguageRelease release = language.lastRelease();
        return this.box.commands(ModelCommands.class).create(name, "(no description)", GavCoordinates.from(language, release), this.owner, "quassar");
    }

    private void copyTemplateWorkspaceTo(Model metamodel) {
        Model templateMetamodel;
        if (metamodel == null) {
            return;
        }
        Model model = templateMetamodel = this.template != null && !this.template.isEmpty() ? this.box.modelManager().get(this.template) : null;
        if (templateMetamodel != null) {
            this.box.modelManager().copyWorkSpace(templateMetamodel, metamodel);
        } else {
            this.createDefaultWorkspace(metamodel);
        }
    }

    private void createDefaultWorkspace(Model model) {
        this.box.modelManager().createFile(model, ModelHelper.validWorkspaceFileName("main.tara"), null, null);
    }
}

