/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractModelSettingsEditor;
import io.quassar.editor.box.ui.displays.templates.LanguageKitTemplate;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class ModelSettingsEditor
extends AbstractModelSettingsEditor<EditorBox> {
    private Model model;
    private Consumer<Model> saveNameListener;
    private Consumer<Model> cloneListener;
    private Consumer<Model> updateLanguageVersionListener;
    private String release;

    public ModelSettingsEditor(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String release) {
        this.release = release;
    }

    public void onSaveName(Consumer<Model> listener) {
        this.saveNameListener = listener;
    }

    public void onClone(Consumer<Model> listener) {
        this.cloneListener = listener;
    }

    public void onUpdateLanguageVersion(Consumer<Model> listener) {
        this.updateLanguageVersionListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.generalBlock.onInit(e -> this.initGeneralBlock());
        this.generalBlock.onShow(e -> this.refreshGeneralBlock());
        this.collaboratorsBlock.onInit(e -> this.initCollaboratorsBlock());
        this.collaboratorsBlock.onShow(e -> this.refreshCollaboratorsBlock());
    }

    public void refresh() {
        super.refresh();
        if (this.model.isExample()) {
            this.settingsTabSelector.hideOption("collaboratorsOption");
        }
        this.settingsTabSelector.select(0);
    }

    private void initGeneralBlock() {
        this.removeModel.onExecute(e -> this.removeModel());
        this.cloneModel.onExecute(e -> this.cloneModel());
        this.editName.onExecute(e -> this.openNameDialog());
        this.nameDialog.onSave(e -> {
            this.modelNameField.value((String)e);
            this.saveNameListener.accept(this.model);
        });
        this.modelDescriptionField.onChange(e -> this.saveDescription());
        this.languageSelector.onSelect(e -> this.saveLanguage());
        this.accessTypeField.onToggle(e -> this.saveAccessType());
    }

    private void refreshGeneralBlock() {
        Language language = ((EditorBox)this.box()).languageManager().get(this.model.language());
        boolean canRemove = PermissionsHelper.canRemove(this.model, this.session(), (EditorBox)this.box());
        this.editName.readonly(!PermissionsHelper.canEditName(this.model, (EditorBox)this.box()));
        this.modelNameField.value(ModelHelper.label(this.model, this.language(), (EditorBox)this.box()));
        this.modelDescriptionField.value(this.model.description());
        this.modelDescriptionField.readonly(this.model.isTemplate());
        this.languageName.value(this.model.language().languageId());
        this.languageSelector.clear();
        this.languageSelector.addAll((List)language.releases().stream().map(LanguageRelease::version).toList().reversed());
        this.languageSelector.selection(new String[]{this.model.language().version()});
        this.languageSelector.readonly(this.model.isExample() || this.model.isTemplate());
        this.removeModel.readonly(!canRemove);
        this.removeModel.formats(Set.of("airRight", "whiteColor", canRemove ? "redBackground" : "disabledButton"));
        this.generalBlock.cloneModelBlock.visible(!this.model.isTemplate() && !this.model.isExample());
        this.cloneModel.readonly(!PermissionsHelper.canClone(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.refreshAccessTypeBlock();
    }

    private void refreshAccessTypeBlock() {
        this.generalBlock.accessTypeBlock.visible(false);
        if (!this.generalBlock.accessTypeBlock.isVisible()) {
            return;
        }
        this.accessTypeField.state(this.model.isPrivate() ? ToggleEvent.State.On : ToggleEvent.State.Off);
        this.accessTypeField.readonly(this.model.isExample() || this.model.isTemplate());
    }

    private void initCollaboratorsBlock() {
        this.collaboratorsStamp.onChange(this::saveCollaborators);
    }

    private void refreshCollaboratorsBlock() {
        this.collaboratorsStamp.owner(this.model.owner());
        this.collaboratorsStamp.collaborators(this.model.collaborators());
        this.collaboratorsStamp.refresh();
    }

    private void saveDescription() {
        ((EditorBox)this.box()).commands(ModelCommands.class).saveDescription(this.model, this.modelDescriptionField.value(), this.username());
    }

    private void saveAccessType() {
        boolean isPrivate;
        boolean bl = isPrivate = this.accessTypeField.state() == ToggleEvent.State.On;
        if (isPrivate) {
            ((EditorBox)this.box()).commands(ModelCommands.class).makePrivate(this.model, this.username());
        } else {
            ((EditorBox)this.box()).commands(ModelCommands.class).makePublic(this.model, this.username());
        }
    }

    private void saveLanguage() {
        String selected;
        List selection = this.languageSelector.selection();
        String string = selected = !selection.isEmpty() ? (String)selection.getFirst() : null;
        if (this.model.language().version().equals(selected)) {
            return;
        }
        ((EditorBox)this.box()).commands(ModelCommands.class).updateLanguageVersion(this.model, selected, this.username());
        this.updateLanguageVersionListener.accept(this.model);
    }

    private void saveCollaborators(List<String> collaborators) {
        ((EditorBox)this.box()).commands(ModelCommands.class).save(this.model, collaborators, this.username());
    }

    private void removeModel() {
        String languageId = this.model.language().languageId();
        this.notifyUser(this.translate("Removing model..."), UserMessage.Type.Loading);
        ((EditorBox)this.box()).commands(ModelCommands.class).remove(this.model, this.username());
        this.hideUserNotification();
        if (this.model.isExample()) {
            this.doClose();
        } else {
            ((TemplateNotifier)this.notifier).dispatch(PathHelper.languagePath(languageId));
        }
    }

    private void doClose() {
        this.closeTrigger.launch();
        ((EditorBox)this.box()).souls().stream().filter(Objects::nonNull).map(s -> s.displays(LanguageKitTemplate.class)).flatMap(Collection::stream).distinct().forEach(d -> d.notifyRemove(this.model));
    }

    private void cloneModel() {
        this.cloneListener.accept(this.model);
    }

    private void openNameDialog() {
        this.nameDialog.model(this.model);
        this.nameDialog.open();
    }
}

