/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models.writers;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.FileWriter;
import io.quassar.editor.box.models.Workspace;
import io.quassar.editor.box.util.WorkspaceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class ResourcesWriter
implements FileWriter {
    private final Workspace workspace;

    public ResourcesWriter(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public File create(String filename, InputStream content, File parent) {
        try {
            java.io.File destiny = new java.io.File(this.location(parent), filename);
            FileUtils.copyInputStreamToFile((InputStream)content, (java.io.File)destiny);
            return new File(destiny.getName(), WorkspaceHelper.relativePath(destiny, this.workspace), false, new ArrayList<String>());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public File createFolder(String name, File parent) {
        java.io.File destiny = new java.io.File(this.location(parent), name);
        destiny.mkdirs();
        return new File(destiny.getName(), WorkspaceHelper.relativePath(destiny, this.workspace), true, new ArrayList<String>());
    }

    @Override
    public void save(File file, InputStream content) {
        try {
            java.io.File destiny = this.location(file);
            FileUtils.copyInputStreamToFile((InputStream)content, (java.io.File)destiny);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    @Override
    public File rename(File file, String newName) {
        try {
            java.io.File source = this.location(file);
            java.io.File destiny = new java.io.File(this.location(file).getParentFile(), newName);
            Files.move(source.toPath(), destiny.toPath(), new CopyOption[0]);
            return new File(destiny.getName(), WorkspaceHelper.relativePath(destiny, this.workspace), file.isDirectory(), new ArrayList<String>());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public File move(File file, File directory) {
        try {
            java.io.File source = this.location(file);
            java.io.File destiny = this.location(directory);
            Files.move(source.toPath(), new java.io.File(destiny, file.name()).toPath(), new CopyOption[0]);
            return new File(destiny.getName(), WorkspaceHelper.relativePath(destiny, this.workspace), file.isDirectory(), new ArrayList<String>());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public File copy(String filename, File sourceFile) {
        try {
            java.io.File source = this.location(sourceFile);
            java.io.File destiny = new java.io.File(this.workspace.root(), filename);
            Files.copy(source.toPath(), destiny.toPath(), new CopyOption[0]);
            return new File(destiny.getName(), WorkspaceHelper.relativePath(destiny, this.workspace), sourceFile.isDirectory(), new ArrayList<String>());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    @Override
    public void remove(File file) {
        try {
            java.io.File source = this.location(file);
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((java.io.File)source);
            } else {
                source.delete();
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private java.io.File location(File file) {
        if (file == null) {
            return this.workspace.root();
        }
        return new java.io.File(this.workspace.root(), file.uri());
    }
}

