/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.schemas.Message;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.builder.BuildResult;
import io.quassar.editor.box.builder.ModelBuilder;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.TarHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class RebuildLanguagesAction {
    public EditorBox box;
    public Context context = new Context();
    private static final String MessageTemplate = "%s:%s: %s";

    public String execute() {
        try {
            return String.join((CharSequence)"\n ", this.rebuildAll());
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return "ERROR rebuilding languages: " + e.getMessage();
        }
    }

    private List<String> rebuildAll() {
        ArrayList<String> messages = new ArrayList<String>();
        this.box.languageManager().languages().stream().filter(l -> l.metamodel() != null && !l.metamodel().isEmpty()).forEach(l -> messages.addAll(this.rebuild((Language)l)));
        return messages;
    }

    private List<String> rebuild(Language language) {
        ArrayList<String> messages = new ArrayList<String>();
        language.releases().forEach(r -> messages.add(this.rebuild(language, (LanguageRelease)r)));
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String rebuild(Language language, LanguageRelease release) {
        File destination = null;
        try {
            Logger.info((String)("Building " + language.name() + ":" + release.version()));
            Model model = this.box.modelManager().get(language.metamodel());
            BuildResult result = new ModelBuilder(model, release.version(), new GavCoordinates(language.collection(), language.name(), release.version()), this.box).build("quassar");
            if (!result.success()) {
                String string = this.messageOf(language, release, result);
                return string;
            }
            Resource resource = result.zipArtifacts();
            destination = this.box.archetype().tmp().builds(UUID.randomUUID().toString());
            TarHelper.extract(resource.inputStream(), destination);
            this.box.languageManager().saveDsl(language, release.version(), LanguageHelper.dslOf(destination));
            this.box.languageManager().saveDslManifest(language, release.version(), LanguageHelper.dslManifestOf(destination));
            this.box.languageManager().saveLsp(language, release.version(), LanguageHelper.lspOf(destination));
            this.box.languageManager().saveLspManifest(language, release.version(), LanguageHelper.lspManifestOf(destination));
            this.box.languageManager().saveGraph(language, release.version(), LanguageHelper.graphOf(destination));
            this.box.languageManager().saveParsers(language, release.version(), LanguageHelper.parsersOf(destination));
            String string = this.messageOf(language, release, result);
            return string;
        }
        catch (InternalServerError | NotFound | Exception e) {
            Logger.error((Throwable)e);
            String string = this.messageOf(language, release, BuildResult.failure(List.of(new Message().content(e.getMessage()).kind(Message.Kind.ERROR))));
            return string;
        }
        finally {
            if (destination != null) {
                destination.delete();
            }
        }
    }

    private String messageOf(Language language, LanguageRelease release, BuildResult result) {
        String message = result.success() ? "SUCCESS" : "ERROR -> " + String.join((CharSequence)"; ", result.messages().stream().map(Message::content).toList());
        return String.format(MessageTemplate, language.name(), release.version(), message);
    }
}

