/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.Commands;
import io.quassar.editor.box.commands.language.CreateLanguageCommand;
import io.quassar.editor.box.commands.language.CreateLanguageReleaseCommand;
import io.quassar.editor.box.commands.language.CreateLanguageReleaseExecutionCommand;
import io.quassar.editor.box.commands.language.MakeLanguagePrivateCommand;
import io.quassar.editor.box.commands.language.MakeLanguagePublicCommand;
import io.quassar.editor.box.commands.language.RemoveLanguageCommand;
import io.quassar.editor.box.commands.language.RemoveLanguageReleaseCommand;
import io.quassar.editor.box.commands.language.RenameLanguageCommand;
import io.quassar.editor.box.commands.language.SaveLanguageCommand;
import io.quassar.editor.box.commands.language.SaveLanguageHelpCommand;
import io.quassar.editor.box.commands.language.SaveLanguagePropertyCommand;
import io.quassar.editor.box.commands.language.SaveLanguageReleaseExecutionCommand;
import io.quassar.editor.box.commands.language.SaveLanguageReleaseExecutionPropertiesCommand;
import io.quassar.editor.model.Collection;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageExecution;
import io.quassar.editor.model.LanguageProperty;
import io.quassar.editor.model.Model;
import java.io.File;
import java.util.List;

public class LanguageCommands
extends Commands {
    public LanguageCommands(EditorBox box) {
        super(box);
    }

    public Language create(Collection collection, String name, Model metamodel, Language.Level level, boolean isPrivate, File logo, String username) {
        CreateLanguageCommand command = this.setup(new CreateLanguageCommand(this.box), username);
        command.collection = collection;
        command.name = name;
        command.metamodel = metamodel;
        command.level = level;
        command.isPrivate = isPrivate;
        command.logo = logo;
        return command.execute();
    }

    public Command.CommandResult createRelease(Language language, String version, String username) {
        CreateLanguageReleaseCommand command = this.setup(new CreateLanguageReleaseCommand(this.box), username);
        command.language = language;
        command.version = version;
        return command.execute();
    }

    public void save(Language language, LanguageProperty property, Object value, String username) {
        SaveLanguagePropertyCommand command = this.setup(new SaveLanguagePropertyCommand(this.box), username);
        command.language = language;
        command.property = property;
        command.value = value;
        command.execute();
    }

    public Language rename(Language language, String newName, String username) {
        RenameLanguageCommand command = this.setup(new RenameLanguageCommand(this.box), username);
        command.language = language;
        command.newId = newName;
        return command.execute();
    }

    public void save(Language language, String title, String description, Language.Level level, List<String> tags, File logo, String username) {
        SaveLanguageCommand command = this.setup(new SaveLanguageCommand(this.box), username);
        command.language = language;
        command.title = title;
        command.description = description;
        command.level = level;
        command.tags = tags;
        command.logo = logo;
        command.execute();
    }

    public void saveHelp(Language language, String release, String content, String username) {
        SaveLanguageHelpCommand command = this.setup(new SaveLanguageHelpCommand(this.box), username);
        command.language = language;
        command.release = release;
        command.content = content;
        command.execute();
    }

    public Boolean remove(Language language, String username) {
        RemoveLanguageCommand command = this.setup(new RemoveLanguageCommand(this.box), username);
        command.language = language;
        return command.execute();
    }

    public Boolean remove(Language language, String release, String username) {
        RemoveLanguageReleaseCommand command = this.setup(new RemoveLanguageReleaseCommand(this.box), username);
        command.language = language;
        command.release = release;
        return command.execute();
    }

    public LanguageExecution createExecution(Language language, String release, String name, LanguageExecution.Type type, String username) {
        CreateLanguageReleaseExecutionCommand command = this.setup(new CreateLanguageReleaseExecutionCommand(this.box), username);
        command.language = language;
        command.release = release;
        command.name = name;
        command.type = type;
        return command.execute();
    }

    public void saveExecution(Language language, String release, String name, LanguageExecution.Type type, String content, String username) {
        SaveLanguageReleaseExecutionCommand command = this.setup(new SaveLanguageReleaseExecutionCommand(this.box), username);
        command.language = language;
        command.release = release;
        command.name = name;
        command.type = type;
        command.content = content;
        command.execute();
    }

    public void saveExecutionProperties(Language language, String release, String installationUrl, String username) {
        SaveLanguageReleaseExecutionPropertiesCommand command = this.setup(new SaveLanguageReleaseExecutionPropertiesCommand(this.box), username);
        command.language = language;
        command.release = release;
        command.installationUrl = installationUrl;
        command.execute();
    }

    public void makePrivate(Language language, String username) {
        MakeLanguagePrivateCommand command = this.setup(new MakeLanguagePrivateCommand(this.box), username);
        command.language = language;
        command.execute();
    }

    public void makePublic(Language language, String username) {
        MakeLanguagePublicCommand command = this.setup(new MakeLanguagePublicCommand(this.box), username);
        command.language = language;
        command.execute();
    }
}

