/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageLogoDialog;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.model.Language;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class LanguageLogoDialog
extends AbstractLanguageLogoDialog<EditorBox> {
    private Language language;
    private Function<Boolean, String> idProvider;
    private Function<Boolean, String> nameProvider;
    private Consumer<File> changeLogoListener;
    private boolean logoExists;
    private File selectedLogo;

    public LanguageLogoDialog(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
        this.resetLogo();
    }

    public void languageIdProvider(Function<Boolean, String> provider) {
        this.idProvider = provider;
    }

    public void languageNameProvider(Function<Boolean, String> provider) {
        this.nameProvider = provider;
    }

    public void onChangeLogo(Consumer<File> listener) {
        this.changeLogoListener = listener;
    }

    public File logo() {
        if (!this.logoExists) {
            return null;
        }
        File tmpFile = new File(((EditorBox)this.box()).archetype().tmp().root(), this.id() + "-logo.png");
        return tmpFile.exists() ? tmpFile : (this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : null);
    }

    public void readonly(boolean value) {
        this.openDialogTrigger.readonly(value);
    }

    public void generateDefaultLogo() {
        this.generateLogo();
        this.saveLogo();
    }

    @Override
    public void init() {
        super.init();
        this.logoField.onChange(this::changeLogo);
        this.generateLogo.onExecute(e -> this.generateLogo());
        this.dialog.onOpen(e -> this.refreshDialog());
        this.cancelLogo.onExecute(e -> {
            this.resetLogo();
            this.dialog.close();
        });
        this.changeLogo.onExecute(e -> this.saveLogo());
    }

    public void refresh() {
        super.refresh();
        File logo = this.selectedLogo != null && this.selectedLogo.exists() ? this.selectedLogo : (this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : null);
        boolean bl = this.logoExists = logo != null && logo.exists();
        if (this.logoExists) {
            this.logo.value(logo);
        } else {
            this.logo.value(LanguageLogoDialog.class.getResource("/images/language-logo.png"));
        }
    }

    private void refreshDialog() {
        File logo = this.selectedLogo != null && this.selectedLogo.exists() ? this.selectedLogo : (this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : null);
        boolean bl = this.logoExists = logo != null && logo.exists();
        if (this.logoExists) {
            this.logoPreview.value(logo);
        } else {
            this.logoPreview.value(LanguageLogoDialog.class.getResource("/images/language-logo.png"));
        }
        this.logoField.value(null);
        this.languageId.value(this.idProvider.apply(true));
    }

    private void changeLogo(ChangeEvent event) {
        try {
            Resource value;
            File tmpFile = this.logoFile();
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            this.logoExists = (value = (Resource)event.value()) != null;
            this.selectedLogo = tmpFile;
            if (value != null) {
                Files.write(tmpFile.toPath(), value.bytes(), new OpenOption[0]);
            }
            this.logoPreview.value(value != null ? tmpFile : null);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    @NotNull
    private File logoFile() {
        return new File(((EditorBox)this.box()).archetype().tmp().root(), this.id() + "-logo.png");
    }

    private void saveLogo() {
        File logo;
        this.dialog.close();
        File file = this.logoFile().exists() ? this.logoFile() : (logo = this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : null);
        if (this.changeLogoListener != null) {
            this.changeLogoListener.accept(logo);
        }
        this.selectedLogo = logo = this.logoFile().exists() ? this.logoFile() : (this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : null);
        this.logo.value(logo);
    }

    private void generateLogo() {
        File destiny = this.logoFile();
        if (destiny.exists()) {
            destiny.delete();
        }
        this.selectedLogo = destiny;
        LanguageHelper.generateLogo(this.nameProvider.apply(true), destiny);
        this.logoPreview.value(destiny);
    }

    private void resetLogo() {
        this.selectedLogo = null;
    }
}

