/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.model;

import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.SubjectWrapper;
import io.quassar.editor.model.Visibility;
import java.time.Instant;
import java.util.List;
import systems.intino.datamarts.subjectstore.model.Subject;

public class Model
extends SubjectWrapper {
    public static final String DraftRelease = "draft";

    public Model(Subject subject) {
        super(subject);
    }

    public static String qualifiedTitleFor(String project, String module) {
        return project + (String)(module != null && !module.isEmpty() ? ": " + module : "");
    }

    public String id() {
        return this.subject.name();
    }

    public String name() {
        return this.getOrEmpty("name");
    }

    public void name(String value) {
        this.set("name", value);
    }

    public String title() {
        return this.get("title");
    }

    public void title(String value) {
        this.set("title", value);
        this.set("qualified-title", "");
    }

    public boolean isTitleQualified() {
        return !this.qualifiedTitle().isEmpty();
    }

    public String qualifiedTitle() {
        return this.getOrEmpty("qualified-title");
    }

    public String project() {
        return this.getOrEmpty("project");
    }

    public String module() {
        return this.getOrEmpty("module");
    }

    public void qualifiedTitle(String project, String module) {
        this.set("qualified-title", Model.qualifiedTitleFor(project, module));
        this.set("project", project);
        this.set("module", module);
    }

    public String description() {
        return this.get("description");
    }

    public void description(String value) {
        this.set("description", value);
    }

    public GavCoordinates language() {
        return Model.language(this.subject);
    }

    public static GavCoordinates language(Subject subject) {
        return new GavCoordinates(subject.get("language-group"), subject.get("language-name"), subject.get("language-version"));
    }

    public void language(GavCoordinates value) {
        this.set("language-group", value.groupId());
        this.set("language-name", value.artifactId());
        this.set("language-version", value.version());
    }

    public String owner() {
        return Model.owner(this.subject);
    }

    public static String owner(Subject subject) {
        return subject.get("owner");
    }

    public void owner(String owner) {
        this.set("owner", owner);
    }

    public Instant createDate() {
        return Instant.parse(this.get("create-date"));
    }

    public void createDate(Instant date) {
        this.set("create-date", date.toString());
    }

    public List<String> collaborators() {
        return this.getList("collaborator");
    }

    public void collaborators(List<String> values) {
        this.putList("collaborator", values);
    }

    public void add(String collaborator) {
        this.put("collaborator", collaborator);
    }

    public boolean isPublic() {
        return !this.isPrivate();
    }

    public boolean isPrivate() {
        return this.visibility() == Visibility.Private;
    }

    public void isPrivate(boolean value) {
        this.visibility(value ? Visibility.Private : Visibility.Public);
    }

    public Visibility visibility() {
        return this.get("visibility") == null ? Visibility.Private : Visibility.valueOf(this.get("visibility"));
    }

    public void visibility(Visibility value) {
        this.set("visibility", value.name());
    }

    public boolean isExample() {
        return this.usage() == Usage.Example;
    }

    public boolean isTemplate() {
        return this.usage() == Usage.Template;
    }

    public Usage usage() {
        return Usage.valueOf(this.get("usage"));
    }

    public void usage(Usage usage) {
        this.set("usage", usage.name());
    }

    public boolean isDraft(String release) {
        return release != null && release.equals(DraftRelease);
    }

    public static enum Usage {
        Template,
        Example,
        EndUser;

    }
}

