/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractProjectModuleEntryViewer;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Model;
import java.util.function.Consumer;

public class ProjectModuleEntryViewer
extends AbstractProjectModuleEntryViewer<EditorBox> {
    private Model model;
    private boolean selected;
    private Consumer<Boolean> selectListener;

    public ProjectModuleEntryViewer(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void selected(boolean value) {
        this.selected = value;
    }

    public void onSelect(Consumer<Boolean> listener) {
        this.selectListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.titleLink.onExecute(e -> this.open());
    }

    public void refresh() {
        super.refresh();
        this.refreshLink();
        this.refreshText();
    }

    private void refreshLink() {
        this.titleLink.visible(!this.selected);
        if (!this.titleLink.isVisible()) {
            return;
        }
        this.titleLink.title(this.model.language().languageId());
    }

    private void refreshText() {
        this.titleText.visible(this.selected);
        if (!this.titleText.isVisible()) {
            return;
        }
        this.titleText.value(this.model.language().languageId());
    }

    private void open() {
        ((TemplateNotifier)this.notifier).dispatch(PathHelper.modelPath(this.model));
        this.selectListener.accept(true);
    }
}

