/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.model.Datasource;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.datasources.ModelsDatasource;
import io.quassar.editor.box.ui.displays.items.ModelItem;
import io.quassar.editor.box.ui.displays.templates.AbstractModelsTemplate;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.util.Collections;
import java.util.function.Function;

public class ModelsTemplate
extends AbstractModelsTemplate<EditorBox> {
    private Language language;
    private LanguageRelease release;
    private LanguageTab tab;
    private Function<Boolean, Model> createModelListener;
    private Mode mode = Mode.Normal;

    public ModelsTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(LanguageRelease release) {
        this.release = release;
    }

    public void tab(LanguageTab tab) {
        this.tab = tab;
    }

    public void mode(Mode mode) {
        this.mode = mode;
    }

    public void onCreateModel(Function<Boolean, Model> listener) {
        this.createModelListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.addModelTrigger.onExecute(e -> this.notifyCreateModel());
        this.modelList.onAddItem(this::refresh);
    }

    public void refresh() {
        super.refresh();
        this.addModelTrigger.visible(this.createModelListener != null && PermissionsHelper.canAddModel(this.language, this.session(), (EditorBox)this.box()));
        ModelsDatasource source = new ModelsDatasource((EditorBox)this.box(), this.session(), this.language, this.release, this.tab);
        this.modelList.source((Datasource)source);
        this.modelList.reload();
        this.searchBox.visible(source.itemCount(null, Collections.emptyList()) > DisplayHelper.MinItemsCount);
    }

    private void refresh(AddCollectionItemEvent event) {
        this.refresh((Model)event.item(), (ModelItem)event.component());
    }

    private void refresh(Model model, ModelItem display) {
        display.label.visible(this.mode == Mode.Normal);
        if (display.label.isVisible()) {
            display.label.title(ModelHelper.label(model, this.language(), (EditorBox)this.box()));
            display.label.address(path -> PathHelper.modelPath(path, model));
        }
        display.siteLabel.visible(this.mode == Mode.Forge);
        if (display.siteLabel.isVisible()) {
            display.siteLabel.title(ModelHelper.label(model, this.language(), (EditorBox)this.box()));
            display.siteLabel.site(PathHelper.modelUrl(model, this.session()));
        }
        display.description.value(model.description() != null && !model.description().equals(this.translate("(no description)")) ? model.description() : null);
        display.owner.visible(true);
        if (display.owner.isVisible()) {
            display.owner.value(model.owner());
        }
        display.version.visible(true);
        if (display.version.isVisible()) {
            display.version.value(model.language().version());
        }
        display.createDate.value(model.createDate());
    }

    private void notifyCreateModel() {
        if (this.createModelListener == null) {
            return;
        }
        Model model = this.createModelListener.apply(true);
        if (this.mode == Mode.Normal) {
            ((TemplateNotifier)this.notifier).dispatch(PathHelper.startingModelPath(model));
        } else {
            this.modelTrigger.site(PathHelper.modelUrl(model, this.session()));
            this.modelTrigger.launch();
        }
    }

    public static enum Mode {
        Normal,
        Forge;

    }
}

