/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageForgeTemplate;
import io.quassar.editor.box.ui.types.ForgeView;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.util.List;
import java.util.SequencedCollection;

public class LanguageForgeTemplate
extends AbstractLanguageForgeTemplate<EditorBox> {
    private Language language;
    private String release;
    private ForgeView view;

    public LanguageForgeTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void view(ForgeView view) {
        this.view = view;
    }

    @Override
    public void init() {
        super.init();
        this.infoLink.onExecute(e -> this.showInfoBlock());
        this.infoDialog.onOpen(e -> this.refreshInfoDialog());
        this.infoDialog.onClose(e -> this.refreshProperties());
        this.helpBlock.onInit(e -> this.initHelpBlock());
        this.helpBlock.onShow(e -> this.refreshHelpBlock());
        this.kitBlock.onInit(e -> this.initKitBlock());
        this.kitBlock.onShow(e -> this.refreshKitBlock());
        this.executionBlock.onInit(e -> this.initExecutionBlock());
        this.executionBlock.onShow(e -> this.refreshExecutionBlock());
        this.viewSelector.select(0);
        this.versionSelector.onSelect(e -> this.updateVersion());
        this.refreshVersions.onExecute(e -> this.refreshVersions());
    }

    public void refresh() {
        super.refresh();
        this.refreshProperties();
        this.refreshVersions();
        this.refreshFooter();
        this.refreshView();
    }

    private void showInfoBlock() {
        this.infoDialog.open();
    }

    private void refreshView() {
        Model model = ((EditorBox)this.box()).modelManager().get(this.language.metamodel());
        this.viewSelector.address(path -> PathHelper.forgePath(path, model.id(), this.release));
        if (this.view != null) {
            this.viewSelector.selection(this.view.name());
        }
        this.hideViews();
        if (this.view == ForgeView.Help) {
            this.helpBlock.show();
        } else if (this.view == ForgeView.Kit) {
            this.kitBlock.show();
        } else if (this.view == ForgeView.Execution) {
            this.executionBlock.show();
        } else {
            this.kitBlock.show();
        }
    }

    private void hideViews() {
        if (this.helpBlock.isVisible()) {
            this.helpBlock.hide();
        } else if (this.kitBlock.isVisible()) {
            this.kitBlock.hide();
        } else if (this.executionBlock.isVisible()) {
            this.executionBlock.hide();
        }
    }

    private void refreshInfoDialog() {
        this.infoStamp.language(this.language);
        this.infoStamp.release(this.release);
        this.infoStamp.refresh();
    }

    private void initHelpBlock() {
        this.helpStamp.onCreateVersion(this::versionCreated);
    }

    private void refreshHelpBlock() {
        this.helpStamp.language(this.language);
        this.helpStamp.release(this.release);
        this.helpStamp.refresh();
    }

    private void initKitBlock() {
        this.kitStamp.onCreateVersion(this::versionCreated);
    }

    private void refreshKitBlock() {
        this.kitStamp.language(this.language);
        this.kitStamp.release(this.release);
        this.kitStamp.refresh();
    }

    private void initExecutionBlock() {
        this.executionStamp.onCreateVersion(this::versionCreated);
    }

    private void refreshExecutionBlock() {
        this.executionStamp.language(this.language);
        this.executionStamp.release(this.release);
        this.executionStamp.refresh();
    }

    private void refreshProperties() {
        this.logo.value(LanguageHelper.logo(this.language, (EditorBox)this.box()));
        this.languageName.value(this.language.name().toLowerCase());
    }

    private void refreshVersions() {
        Model metamodel = ((EditorBox)this.box()).modelManager().get(this.language.metamodel());
        SequencedCollection releases = ((EditorBox)this.box()).modelManager().releases(metamodel).reversed();
        this.versionSelector.address(path -> PathHelper.forgeReleasePath(path, metamodel.id(), (String)this.viewSelector.selection().getFirst()));
        this.versionSelector.clear();
        this.versionSelector.addAll((List)releases);
        if (this.release != null) {
            this.versionSelector.selection(new String[]{this.release});
        }
    }

    private void refreshFooter() {
        Language parentLanguage = ((EditorBox)this.box()).languageManager().get(this.language.parent());
        this.parentLanguageBlock.visible(parentLanguage != null);
        if (parentLanguage == null) {
            return;
        }
        this.parentLanguageImage.value(LanguageHelper.logo(parentLanguage, (EditorBox)this.box()));
        this.parentLanguageTitle.value("%s forge".formatted(parentLanguage.name()));
        this.parentLanguageLink.address(path -> PathHelper.languagePath(this.language));
    }

    private void updateVersion() {
        List selection = this.versionSelector.selection();
        this.release = !selection.isEmpty() ? (String)selection.getFirst() : null;
        this.refreshView();
    }

    private void versionCreated(Command.CommandResult result) {
        if (!result.success()) {
            this.notifyUser(this.translate("Could not create version"), UserMessage.Type.Error);
        }
        this.refresh();
    }
}

