/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageEditor;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.model.Language;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class LanguageEditor
extends AbstractLanguageEditor<EditorBox> {
    private Language language;
    private boolean logoExists;
    private Consumer<Boolean> checkIdListener;
    private Consumer<String> changeIdListener;
    private Consumer<File> changeLogoListener;

    public LanguageEditor(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void onCheckId(Consumer<Boolean> listener) {
        this.checkIdListener = listener;
    }

    public void onChangeId(Consumer<String> listener) {
        this.changeIdListener = listener;
    }

    public void onChangeLogo(Consumer<File> listener) {
        this.changeLogoListener = listener;
    }

    public String languageId() {
        return this.idField.value();
    }

    public File logo() {
        if (!this.logoExists) {
            return null;
        }
        File tmpFile = new File(((EditorBox)this.box()).archetype().tmp().root(), this.id() + "-logo.png");
        return tmpFile.exists() ? tmpFile : (this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : null);
    }

    public void focus() {
        this.idField.focus();
    }

    public boolean check() {
        return DisplayHelper.checkLanguageId(this.idField, arg_0 -> ((LanguageEditor)this).translate(arg_0), (EditorBox)this.box()) && DisplayHelper.checkLanguageInUse(this.idField, arg_0 -> ((LanguageEditor)this).translate(arg_0), (EditorBox)this.box());
    }

    @Override
    public void init() {
        super.init();
        this.idField.onEnterPress(e -> this.changeName());
        this.idField.onChange(e -> this.refreshState());
        this.changeId.onExecute(e -> this.changeName());
        this.changeId.signChecker((sign, reason) -> sign.equals(this.idField.value()));
        this.logoField.onChange(this::updateLogo);
        this.generateLogo.onExecute(e -> this.generateLogo());
    }

    public void refresh() {
        super.refresh();
        File logo = this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : null;
        this.logoExists = logo != null && logo.exists();
        this.idField.value(this.language != null ? this.language.key() : null);
        this.logoField.value(this.logoExists ? logo : null);
        this.changeId.visible(this.language != null);
        this.generateLogo.readonly(this.language == null);
        if (this.changeId.isVisible()) {
            this.changeId.readonly(true);
        }
    }

    private void refreshState() {
        boolean valid;
        boolean sameName = this.language == null || Language.nameFrom(this.idField.value()).equals(this.language.name());
        boolean bl = valid = sameName && DisplayHelper.checkLanguageId(this.idField, arg_0 -> ((LanguageEditor)this).translate(arg_0), (EditorBox)this.box()) && (this.language != null || DisplayHelper.checkLanguageInUse(this.idField, arg_0 -> ((LanguageEditor)this).translate(arg_0), (EditorBox)this.box()));
        if (!sameName) {
            this.idField.error(this.translate("DSL can't change its name part (%s) once created").formatted(this.language.name()));
        }
        boolean emptyId = this.idField.value() == null || this.idField.value().isEmpty();
        this.validIdIcon.visible(valid && !emptyId);
        this.invalidIdIcon.visible(!valid && !emptyId);
        this.generateLogo.readonly(emptyId);
        this.changeId.readonly(!valid);
        if (this.checkIdListener != null) {
            this.checkIdListener.accept(valid);
        }
    }

    private void generateLogo() {
        File destiny = this.logoFile();
        if (destiny.exists()) {
            destiny.delete();
        }
        LanguageHelper.generateLogo(Language.nameFrom(this.idField.value()), destiny);
        if (this.changeLogoListener != null) {
            this.changeLogoListener.accept(destiny);
        }
        this.logoField.value(this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : destiny);
    }

    private void updateLogo(ChangeEvent event) {
        try {
            Resource value;
            File tmpFile = this.logoFile();
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            boolean bl = this.logoExists = (value = (Resource)event.value()) != null;
            if (value != null) {
                Files.write(tmpFile.toPath(), value.bytes(), new OpenOption[0]);
            }
            if (this.changeLogoListener != null) {
                this.changeLogoListener.accept(value != null ? this.logo() : null);
            }
            this.logoField.value(value != null ? (this.language != null ? ((EditorBox)this.box()).languageManager().loadLogo(this.language) : tmpFile) : null);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    @NotNull
    private File logoFile() {
        return new File(((EditorBox)this.box()).archetype().tmp().root(), this.id() + "-logo.png");
    }

    private void changeName() {
        if (this.changeIdListener == null) {
            return;
        }
        this.changeIdListener.accept(this.idField.value());
        this.refresh();
    }
}

