/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.builderservice.schemas.Message;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractConsoleEntryTemplate;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.FilePosition;
import io.quassar.editor.model.Model;

public class ConsoleEntryTemplate
extends AbstractConsoleEntryTemplate<EditorBox> {
    private Model model;
    private String release;
    private Message message;

    public ConsoleEntryTemplate(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String release) {
        this.release = release;
    }

    public void message(Message message) {
        this.message = message;
    }

    public void refresh() {
        super.refresh();
        this.infoIcon.visible(this.message.kind() == Message.Kind.INFO);
        this.warningIcon.visible(this.message.kind() == Message.Kind.WARNING);
        this.errorIcon.visible(this.message.kind() == Message.Kind.ERROR);
        this.file.title(this.message.uri());
        this.file.address(path -> PathHelper.modelPath(path, this.model, this.release, this.message.uri(), new FilePosition(this.message.line(), this.message.column())));
        this.location.value(this.message.line() + ":" + this.message.column());
        this.content.value(this.message.content());
    }
}

