/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.models;

import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.Workspace;
import io.quassar.editor.box.models.WorkspaceReader;
import io.quassar.editor.box.models.readers.ModelReader;
import io.quassar.editor.box.models.readers.ResourcesReader;
import java.util.List;
import org.eclipse.lsp4j.services.LanguageServer;

public class ModelContainer {
    private final Workspace workspace;
    private final LanguageServer server;

    public ModelContainer(Workspace workspace, LanguageServer server) {
        this.workspace = workspace;
        this.server = server;
    }

    public List<File> files() {
        return new WorkspaceReader(this.workspace, this.server).files();
    }

    public List<File> modelFiles() {
        return new WorkspaceReader(this.workspace, this.server).modelFiles();
    }

    public List<File> resourceFiles() {
        return new WorkspaceReader(this.workspace, this.server).resourceFiles();
    }

    public File file(String uri) {
        return File.isResource(uri) ? new ResourcesReader(this.workspace).get(uri) : new ModelReader(this.workspace, this.server).get(uri);
    }
}

