/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.languages;

import io.intino.ls.IntinoLanguageServer;
import io.intino.ls.document.DocumentManager;
import io.intino.ls.document.FileDocumentManager;
import io.intino.ls.document.GitDocumentManager;
import io.intino.tara.Language;
import io.quassar.editor.box.languages.LanguageLoader;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.lsp4j.services.LanguageServer;

public class LanguageServerManager {
    private final LanguageLoader languageLoader;
    private final BiFunction<Model, String, URI> workspaceProvider;
    private final Map<String, LanguageServer> servers = new HashMap<String, LanguageServer>();

    public LanguageServerManager(LanguageLoader languageLoader, BiFunction<Model, String, URI> workspaceProvider) {
        this.languageLoader = languageLoader;
        this.workspaceProvider = workspaceProvider;
    }

    public LanguageServer create(Language language, URI workspaceRoot) throws IOException {
        File root = new File(workspaceRoot);
        root.mkdirs();
        return new IntinoLanguageServer(language, (DocumentManager)new FileDocumentManager(root));
    }

    public LanguageServer create(Language language, URI workspaceRoot, URL gitUrl, String branch, String username, String token) throws IOException, GitAPIException, URISyntaxException {
        File root = new File(workspaceRoot);
        root.mkdirs();
        return new IntinoLanguageServer(language, (DocumentManager)new GitDocumentManager(root, branch, gitUrl, username, token));
    }

    public LanguageServer get(Model model, String release) throws IOException, GitAPIException, URISyntaxException {
        String key = this.key(model, release);
        if (!this.servers.containsKey(key)) {
            this.servers.put(key, this.create(model, release));
        }
        return this.servers.get(key);
    }

    public void remove(Model model, String release) {
        this.servers.remove(this.key(model, release));
    }

    private String key(Model model, String release) {
        return model.id() + release;
    }

    private LanguageServer create(Model model, String release) throws IOException {
        Language language = this.languageLoader.get(model.language());
        URI workspace = this.workspaceProvider.apply(model, release);
        return this.create(language, workspace);
    }

    private URL urlOf(String value) {
        try {
            if (value == null) {
                return null;
            }
            return new URI(value).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }
}

