/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.commands.language;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.schemas.Message;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.builder.BuildResult;
import io.quassar.editor.box.builder.ModelBuilder;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.model.CreateModelCommand;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.TarHelper;
import io.quassar.editor.box.util.ZipHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class CreateLanguageReleaseCommand
extends Command<Command.CommandResult> {
    public Language language;
    public String version;
    private static final String LanguageDir = "language";
    private static final String GraphFilename = "graph.json";

    public CreateLanguageReleaseCommand(EditorBox box) {
        super(box);
    }

    @Override
    public Command.CommandResult execute() {
        BuildResult result = this.build(this.box.modelManager().get(this.language.metamodel()));
        if (!result.success()) {
            return this.resultOf(result);
        }
        LanguageRelease release = this.box.languageManager().createRelease(this.language, this.version);
        this.createDefaultHelp(this.language, release);
        Model template = this.createTemplateModel(this.language, release);
        release.template(template.id());
        return this.resultOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BuildResult build(Model metamodel) {
        File destination = null;
        try {
            BuildResult result = new ModelBuilder(metamodel, new GavCoordinates(this.language.group(), this.language.name(), this.version), this.box).build(this.author);
            if (!result.success()) {
                BuildResult buildResult = result;
                return buildResult;
            }
            Resource resource = result.zipArtifacts();
            destination = this.box.archetype().tmp().builds(UUID.randomUUID().toString());
            TarHelper.extract(resource.inputStream(), destination);
            this.box.languageManager().saveDsl(this.language, this.version, this.dslOf(destination));
            this.box.languageManager().saveGraph(this.language, this.version, this.graphOf(destination));
            this.box.languageManager().saveReaders(this.language, this.version, this.readersOf(destination));
            BuildResult buildResult = result;
            return buildResult;
        }
        catch (InternalServerError | NotFound | Exception e) {
            Logger.error((Throwable)e);
            BuildResult buildResult = BuildResult.failure(List.of(new Message().content(e.getMessage()).kind(Message.Kind.ERROR)));
            return buildResult;
        }
        finally {
            if (destination != null) {
                destination.delete();
            }
        }
    }

    private File dslOf(File destination) {
        File[] files = destination.listFiles();
        if (files == null) {
            return null;
        }
        File dir = Arrays.stream(files).filter(f -> f.getName().equals(LanguageDir)).findFirst().orElse(null);
        if (dir == null) {
            return null;
        }
        File[] languageFiles = dir.listFiles();
        if (languageFiles == null) {
            return null;
        }
        return Arrays.stream(languageFiles).filter(l -> l.getName().endsWith(".jar")).findFirst().orElse(null);
    }

    private File graphOf(File destination) {
        File[] files = destination.listFiles();
        if (files == null) {
            return null;
        }
        return Arrays.stream(files).filter(f -> f.getName().equals(GraphFilename)).findFirst().orElse(null);
    }

    private List<File> readersOf(File destination) throws Exception {
        File[] files = destination.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return CreateLanguageReleaseCommand.compressed(Arrays.stream(files).filter(f -> f.isDirectory() && !f.getName().equals(LanguageDir)).toList());
    }

    private static List<File> compressed(List<File> list) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : list) {
            File zipFile = new File(file.getParent(), file.getName().substring(file.getName().lastIndexOf("-") + 1) + ".zip");
            ZipHelper.zip(file.toPath(), zipFile.toPath());
            result.add(zipFile);
        }
        return result;
    }

    private void createDefaultHelp(Language language, LanguageRelease release) {
        try {
            InputStream stream = CreateModelCommand.class.getResourceAsStream("/templates/language.template.html");
            String content = stream != null ? IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8) : "";
            this.box.languageManager().saveHelp(language, release.version(), content);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private Model createTemplateModel(Language language, LanguageRelease release) {
        CreateModelCommand command = new CreateModelCommand(this.box);
        command.author = this.author;
        command.language = GavCoordinates.fromString(language, release);
        command.name = ModelHelper.proposeName();
        command.title = language.name();
        command.description = "";
        command.usage = Model.Usage.Template;
        command.owner = this.author;
        return command.execute();
    }
}

