/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box;

import io.intino.alexandria.logger.Logger;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.util.DirUtils;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class SubjectGenerator {
    private final EditorBox box;

    public SubjectGenerator(EditorBox box) {
        this.box = box;
    }

    public void generate() {
        Logger.info((String)"Generating default subjects");
        this.registerModels();
        this.registerLanguages();
        Logger.info((String)"Default subjects GENERATED!");
    }

    private void registerLanguages() {
        List<String> lines = this.linesOf(this.box.archetype().configuration().defaultLanguages(), "datamart/default-languages.tsv");
        lines.stream().skip(1L).forEach(this::registerLanguage);
        DirUtils.copyDir("datamart/default-languages", this.box.archetype().languages().root());
    }

    private void registerLanguage(String line) {
        String[] content = line.split("\t");
        Model metamodel = !content[2].isEmpty() ? this.box.modelManager().get(content[2]) : null;
        Language language = this.box.languageManager().create(content[0], content[1], metamodel, Language.Level.valueOf(content[3]), content[4], content[5]);
        this.box.languageManager().createRelease(language, content[6]);
    }

    private void registerModels() {
        List<String> lines = this.linesOf(this.box.archetype().configuration().defaultModels(), "datamart/default-models.tsv");
        lines.stream().skip(1L).forEach(this::registerModel);
        DirUtils.copyDir("datamart/default-models", this.box.archetype().models().root());
    }

    private void registerModel(String line) {
        String[] content = line.split("\t");
        Model model = this.box.modelManager().create(content[0], content[1], content[3], content[4], GavCoordinates.fromString(content[2]), Model.Usage.EndUser, "quassar");
        model.isPrivate(false);
    }

    private List<String> linesOf(File file, String defaultResource) {
        return file.exists() ? this.linesOf(file) : this.linesOf(SubjectGenerator.class.getResource("/" + defaultResource));
    }

    private List<String> linesOf(File file) {
        try {
            return Files.readAllLines(file.toPath());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<String> linesOf(URL resource) {
        try {
            String content = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
            return content != null ? List.of(content.split("\n")) : Collections.emptyList();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }
}

