/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Random;

public class LanguageLogoGenerator {
    public static final int WIDTH = 100;
    public static final int HEIGHT = 100;
    private final BufferedImage image = new BufferedImage(100, 100, 2);
    private final Graphics2D graphics = this.init(this.image.createGraphics());
    private static final Random random = new Random();
    public static final String[] fontNames = "AtomicAge-Regular\nAudiowide-Regular\nBaumans-Regular\nBlackOpsOne-Regular\nBrunoAce-Regular\nCodystar-Regular\nGeostar-Regular\nGeostarFill-Regular\nMali-Bold\nOffside-Regular\nOrbitron-ExtraBold\nPathwayExtreme_72pt-Black\nPlaster-Regular\nRedRose-Bold\nRevalia-Regular\nRowdies-Bold\nRussoOne-Regular\nRye-Regular\nSairaStencilOne-Regular\nSometypeMono-Bold\nStalinistOne-Regular\nSyncopate-Bold\nTektur-Black\nTourney_Expanded-Black\nTrocchi-Regular\nUnbounded-Black\nWallpoet-Regular\nZenTokyoZoo-Regular\n".split("\n");

    private Graphics2D init(Graphics2D graphics) {
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, 100, 100);
        graphics.setComposite(AlphaComposite.SrcOver);
        graphics.setColor(Color.BLACK);
        DecorationFactory.random().decorate(graphics);
        return graphics;
    }

    public LanguageLogoGenerator put(char letter) {
        GlyphVector gv = this.glyphVector(letter);
        Rectangle bounds = gv.getPixelBounds(null, 0.0f, 0.0f);
        int x = (100 - bounds.width) / 2 - bounds.x;
        int y = (100 - bounds.height) / 2 - bounds.y;
        this.graphics.drawGlyphVector(gv, x, y);
        return this;
    }

    private GlyphVector glyphVector(char letter) {
        Font font = this.randomFont();
        this.graphics.setFont(font);
        FontRenderContext frc = this.graphics.getFontRenderContext();
        return font.createGlyphVector(frc, String.valueOf(letter));
    }

    public BufferedImage image() {
        this.graphics.dispose();
        return this.image;
    }

    private static String randomFontName() {
        return fontNames[random.nextInt(fontNames.length)];
    }

    private Font randomFont() {
        return this.load(LanguageLogoGenerator.randomFontName());
    }

    public Font load(String name) {
        Font font;
        block9: {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("generators/dsl-icon-generator/" + name + ".ttf");
            try {
                assert (is != null);
                Font font2 = Font.createFont(0, is);
                font = font2.deriveFont(80.0f);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    System.out.println("not found: " + name);
                    return new Font("SansSerif", 1, 80);
                }
            }
            is.close();
        }
        return font;
    }

    private static class DecorationFactory {
        static final int TOP = 0;
        static final int BOTTOM = 1;
        static final int TOP_BOTTOM = 2;
        static final int U_SHAPE = 3;
        static final int C_SHAPE = 4;
        static final int BOX = 5;

        private DecorationFactory() {
        }

        static Decoration random() {
            return switch (random.nextInt(8)) {
                case 0 -> DecorationFactory::top;
                case 1 -> DecorationFactory::bottom;
                case 2 -> DecorationFactory::fit;
                case 5 -> DecorationFactory::box;
                case 3 -> DecorationFactory::uShape;
                case 4 -> DecorationFactory::cShape;
                default -> g -> {};
            };
        }

        private static void top(Graphics2D g) {
            g.fillRect(0, 0, 100, DecorationFactory.randomSize());
        }

        private static void bottom(Graphics2D g) {
            int size = DecorationFactory.randomSize();
            g.fillRect(0, DecorationFactory.bottom(size), 100, size);
        }

        private static void fit(Graphics2D g) {
            int size = DecorationFactory.randomSize();
            g.fillRect(0, 0, 100, size);
            g.fillRect(0, DecorationFactory.bottom(size), 100, size);
        }

        private static int bottom(int size) {
            return 100 - size;
        }

        private static int right(int size) {
            return 100 - size;
        }

        private static void box(Graphics2D g) {
            int size = DecorationFactory.randomSize();
            g.fillRect(0, 0, 100, size);
            g.fillRect(0, DecorationFactory.bottom(size), 100, size);
            g.fillRect(0, 0, size, 100);
            g.fillRect(DecorationFactory.right(size), 0, size, 100);
        }

        private static void uShape(Graphics2D g) {
            int size = DecorationFactory.randomSize();
            g.fillRect(0, DecorationFactory.bottom(size), 100, size);
            g.fillRect(0, 0, size, 100);
            g.fillRect(DecorationFactory.right(size), 0, size, 100);
        }

        private static void cShape(Graphics2D g) {
            int size = DecorationFactory.randomSize();
            g.fillRect(0, 0, 100, size);
            g.fillRect(0, 0, size, 100);
            g.fillRect(0, DecorationFactory.bottom(size), 100, size);
        }

        static int randomSize() {
            return random.nextInt(8) + 6;
        }
    }

    public static interface Decoration {
        public void decorate(Graphics2D var1);
    }
}

