/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.models.ModelContainer;
import io.quassar.editor.box.schemas.IntinoFileBrowserItem;
import io.quassar.editor.box.schemas.IntinoFileBrowserOperation;
import io.quassar.editor.box.schemas.IntinoFileBrowserOperationShortcut;
import io.quassar.editor.box.ui.displays.IntinoFileBrowser;
import io.quassar.editor.box.ui.displays.templates.AbstractResourcesBrowserTemplate;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.IntinoFileBrowserHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Model;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class ResourcesBrowserTemplate
extends AbstractResourcesBrowserTemplate<EditorBox> {
    private Model model;
    private String release;
    private ModelContainer modelContainer;
    private io.quassar.editor.box.models.File file;
    private Operation operation;
    private Consumer<IntinoFileBrowserItem> openListener;
    private Consumer<io.quassar.editor.box.models.File> changeListener;
    private Consumer<io.quassar.editor.box.models.File> removeListener;
    private Resource uploadedFile;

    public ResourcesBrowserTemplate(EditorBox box) {
        super(box);
    }

    public void model(Model value) {
        this.model = value;
    }

    public void release(String value) {
        this.release = value;
    }

    public void modelContainer(ModelContainer value) {
        this.modelContainer = value;
    }

    public void file(io.quassar.editor.box.models.File value) {
        this.file = value;
    }

    public void selection(String uri) {
        this.file = this.modelContainer.file(uri);
        ((IntinoFileBrowser)this.fileBrowser.display()).select(IntinoFileBrowserHelper.itemOf(this.file));
    }

    public void onOpen(Consumer<IntinoFileBrowserItem> listener) {
        this.openListener = listener;
    }

    public void onChange(Consumer<io.quassar.editor.box.models.File> listener) {
        this.changeListener = listener;
    }

    public void onRemove(Consumer<io.quassar.editor.box.models.File> listener) {
        this.removeListener = listener;
    }

    public void didMount() {
        super.didMount();
        this.createBrowser();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.operationsTrigger.onExecute(e -> this.openBrowserContextMenu());
        this.addFile.onExecute(e -> this.executeFileDialogOperation());
        this.fileUploadBlock.onInit(v -> this.fileUploadField.onChange(e -> {
            this.uploadedFile = (Resource)e.value();
            this.addFile.readonly(this.uploadedFile == null);
        }));
        this.fileFieldBlock.onInit(v -> {
            this.fileField.onChange(e -> this.addFile.readonly(e.value() == null || ((String)e.value()).isEmpty()));
            this.fileField.onEnterPress(e -> this.executeFileDialogOperation());
        });
        this.fileDialog.onOpen(e -> this.refreshFileDialog());
        this.removeFileTrigger.onExecute(e -> this.removeFile());
        this.addFileField.onChange(this::addFile);
        this.createBrowser();
    }

    public void refresh() {
        super.refresh();
        if (this.model == null) {
            return;
        }
        IntinoFileBrowser browser = (IntinoFileBrowser)this.fileBrowser.display();
        browser.itemAddress(PathHelper.modelPath(this.model, this.release) + "&file=:file");
        browser.rootItem("resources");
        browser.items(IntinoFileBrowserHelper.fileBrowserItems(this.modelContainer.resourceFiles()), false, true);
        browser.operations(this.operations());
        browser.selection(this.file != null ? IntinoFileBrowserHelper.itemOf(this.file) : null);
        browser.refresh();
        this.addFileField.readonly(!PermissionsHelper.canEdit(this.model, this.release, this.session()));
    }

    private void createBrowser() {
        IntinoFileBrowser browser = new IntinoFileBrowser((EditorBox)this.box());
        browser.onOpen(f -> this.openListener.accept((IntinoFileBrowserItem)f));
        browser.onExecuteOperation(this::execute);
        browser.onRename(this::rename);
        browser.onMove(this::move);
        this.fileBrowser.clear();
        this.fileBrowser.display(browser);
    }

    private void openBrowserContextMenu() {
        ((IntinoFileBrowser)this.fileBrowser.display()).openContextMenu(this.operations());
    }

    private List<IntinoFileBrowserOperation> operations() {
        if (this.model == null) {
            return Collections.emptyList();
        }
        return List.of(new IntinoFileBrowserOperation().name("Add file...").shortcut(new IntinoFileBrowserOperationShortcut().ctrlKey(true).key("N")).enabled(PermissionsHelper.canEdit(this.model, this.release, this.session())), new IntinoFileBrowserOperation().name("Add folder...").shortcut(new IntinoFileBrowserOperationShortcut().shiftKey(true).ctrlKey(true).key("N")).enabled(PermissionsHelper.canEdit(this.model, this.release, this.session())), new IntinoFileBrowserOperation().name("Rename...").shortcut(new IntinoFileBrowserOperationShortcut().ctrlKey(true).key("R")).enabled(this.file != null && PermissionsHelper.canEdit(this.model, this.release, this.session())), new IntinoFileBrowserOperation().name("Remove").shortcut(new IntinoFileBrowserOperationShortcut().ctrlKey(true).key("Backspace")).enabled(this.file != null && PermissionsHelper.canEdit(this.model, this.release, this.session())));
    }

    private void execute(String operation, IntinoFileBrowserItem target) {
        if (operation.equalsIgnoreCase("add file...")) {
            this.openFileDialog(Operation.AddFile);
        } else if (operation.equalsIgnoreCase("add folder...")) {
            this.openFileDialog(Operation.AddFolder);
        } else if (operation.equalsIgnoreCase("rename...")) {
            this.openFileDialog(Operation.EditFilename);
        } else if (operation.equalsIgnoreCase("remove")) {
            this.removeFileTrigger.launch();
        }
    }

    private void openFileDialog(Operation operation) {
        this.operation = operation;
        this.fileDialog.open();
    }

    private void refreshFileDialog(Operation operation) {
        this.operation = operation;
        this.refreshFileDialog();
    }

    private void refreshFileDialog() {
        if (this.operation == null) {
            return;
        }
        this.fileDialog.title(this.fileDialogTitle());
        this.fileDialogSelector.select(new String[]{"newFileOption"});
        this.selectorBlock.visible(this.operation == Operation.AddFile);
        this.fileField.value(this.operation == Operation.EditFilename ? this.file.name() : null);
    }

    private String fileDialogTitle() {
        if (this.operation == Operation.CopyFile) {
            return this.translate("Copy file");
        }
        if (this.operation == Operation.AddFolder) {
            return this.translate("Add folder");
        }
        if (this.operation == Operation.EditFilename) {
            return this.translate("Edit file name");
        }
        return this.translate("Add file");
    }

    private void executeFileDialogOperation() {
        if (!this.isUploadOperation() && !DisplayHelper.check(this.fileField, arg_0 -> ((ResourcesBrowserTemplate)this).translate(arg_0))) {
            return;
        }
        if (this.isUploadOperation() && this.uploadedFile == null) {
            this.notifyUser(this.translate("Select file to upload"), UserMessage.Type.Warning);
            return;
        }
        this.fileDialog.close();
        if (this.operation == Operation.AddFile && ((String)this.fileDialogSelector.selection().getFirst()).equals("newFileOption")) {
            this.addFile();
        } else if (this.operation == Operation.AddFile) {
            this.uploadFile();
        } else if (this.operation == Operation.CopyFile) {
            this.copyFile();
        } else if (this.operation == Operation.EditFilename) {
            this.rename();
        } else if (this.operation == Operation.AddFolder) {
            this.addFolder();
        }
    }

    private boolean isUploadOperation() {
        return this.operation == Operation.AddFile && ((String)this.fileDialogSelector.selection().getFirst()).equals("uploadFileOption");
    }

    private void addFile(ChangeEvent event) {
        try {
            Resource value = (Resource)event.value();
            if (value == null) {
                return;
            }
            if (ModelHelper.isZip(value.name()) && !ModelHelper.isArchetype(value.name())) {
                ((EditorBox)this.box()).commands(ModelCommands.class).addZip(this.model, ModelView.Resources, value.stream(), this.file, this.username());
            } else {
                this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).createFile(this.model, this.nameOf(value.name()), value.stream(), this.file, this.username()));
            }
            this.refresh();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        finally {
            this.addFileField.value(null);
        }
    }

    private void addFile() {
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).createFile(this.model, this.nameOf(this.fileField.value()), new ByteArrayInputStream(new byte[0]), this.file, this.username()));
    }

    private void uploadFile() {
        try {
            this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).createFile(this.model, this.nameOf(this.uploadedFile.name()), this.uploadedFile.stream(), this.file, this.username()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void copyFile() {
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).copy(this.model, this.nameOf(this.fileField.value()), this.file, this.username()));
    }

    private void rename() {
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).rename(this.model, this.fileField.value(), this.file, this.username()));
    }

    private void addFolder() {
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).createFolder(this.model, this.nameOf(this.fileField.value()), this.file, this.username()));
    }

    private void removeFile() {
        ((EditorBox)this.box()).commands(ModelCommands.class).remove(this.model, this.file, this.username());
        this.removeListener.accept(null);
    }

    private void rename(IntinoFileBrowserItem item, String newName) {
        io.quassar.editor.box.models.File file = this.modelContainer.file(item.uri());
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).rename(this.model, newName, file, this.username()));
    }

    private void move(IntinoFileBrowserItem item, IntinoFileBrowserItem directoryItem) {
        io.quassar.editor.box.models.File file = this.modelContainer.file(item.uri());
        io.quassar.editor.box.models.File directory = directoryItem != null ? this.modelContainer.file(directoryItem.uri()) : null;
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).move(this.model, file, directory, this.username()));
    }

    private String nameOf(String name) {
        return this.file == null ? "resources" + File.separator + name : name;
    }

    private static enum Operation {
        CopyFile,
        AddFile,
        AddFolder,
        EditFilename;

    }
}

