/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.ModelContainer;
import io.quassar.editor.box.ui.displays.templates.AbstractModelTemplate;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.box.util.SessionHelper;
import io.quassar.editor.model.FilePosition;
import io.quassar.editor.model.Model;

public class ModelTemplate
extends AbstractModelTemplate<EditorBox> {
    private Model model;
    private String release;
    private ModelView selectedView;
    private ModelContainer modelContainer;
    private File selectedFile;
    private FilePosition selectedPosition;
    private boolean showHelp = false;

    public ModelTemplate(EditorBox box) {
        super(box);
    }

    public void openStarting(String model) {
        this.open(model, null, null, null, null, true);
    }

    public void openTemplate(String model) {
        this.open(model, "draft", null, null, null, false);
    }

    public void open(String model, String release) {
        this.open(model, release, null, null, null, false);
    }

    public void open(String model, String release, String view, String file, String position) {
        this.open(model, release, view, file, position, false);
    }

    public void open(String model, String release, String view, String file, String position, boolean showHelp) {
        this.model = ((EditorBox)this.box()).modelManager().get(model);
        this.release = release != null ? release : "draft";
        this.selectedView = view != null ? ModelView.from(view) : SessionHelper.modelView(this.session());
        this.modelContainer = this.model != null ? ((EditorBox)this.box()).modelManager().modelContainer(this.model, this.release) : null;
        this.selectedFile = file != null && this.modelContainer != null ? this.modelContainer.file(file) : null;
        this.selectedPosition = position != null ? FilePosition.from(position) : null;
        this.showHelp = showHelp;
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        this.notFoundBlock.visible(!PermissionsHelper.hasPermissions(this.model, this.session()));
        this.refreshContent();
    }

    private void refreshContent() {
        this.contentBlock.visible(PermissionsHelper.hasPermissions(this.model, this.session()));
        if (!this.contentBlock.isVisible()) {
            return;
        }
        this.modelEditor.model(this.model, this.release);
        this.modelEditor.view(this.selectedView);
        this.modelEditor.file(this.selectedFile, this.selectedPosition);
        this.modelEditor.showHelp(this.showHelp);
        this.modelEditor.refresh();
    }
}

