/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.ui.displays.templates.AbstractModelHeaderTemplate;
import io.quassar.editor.box.util.LanguageHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import io.quassar.editor.model.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ModelHeaderTemplate
extends AbstractModelHeaderTemplate<EditorBox> {
    private Model model;
    private String release;
    private File file;
    private Consumer<Model> checkListener;
    private Consumer<Model> cloneListener;
    private BiConsumer<Model, Command.CommandResult> deployListener;
    private Consumer<Model> updateLanguageVersionListener;

    public ModelHeaderTemplate(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String value) {
        this.release = value;
    }

    public void file(File value) {
        this.file = value;
    }

    public void onCheck(Consumer<Model> listener) {
        this.checkListener = listener;
    }

    public void onClone(Consumer<Model> listener) {
        this.cloneListener = listener;
    }

    public void onDeploy(BiConsumer<Model, Command.CommandResult> listener) {
        this.deployListener = listener;
    }

    public void onUpdateLanguageVersion(Consumer<Model> listener) {
        this.updateLanguageVersionListener = listener;
    }

    public void openInfo() {
        this.openSettingsDialog();
    }

    @Override
    public void init() {
        super.init();
        this.releaseSelector.onExecute(e -> this.openRelease(e.option()));
        this.checkTrigger.onExecute(e -> this.check());
        this.commitTrigger.onExecute(e -> this.commit());
        this.cloneTrigger.onExecute(e -> this.cloneModel());
        this.downloadTrigger.onExecute(e -> this.openDownloadDialog());
        this.commitModelDialog.onCommit((m, v) -> this.openRelease((String)v));
        this.commitModelDialog.onCommitFailure((m, v) -> this.deployListener.accept((Model)m, (Command.CommandResult)v));
        this.commitModelDialog.onCreateRelease((m, v) -> this.deployListener.accept((Model)m, (Command.CommandResult)v));
        this.infoTrigger.onExecute(e -> this.openSettingsDialog());
        this.modelSettingsDialog.onSave(e -> this.refresh());
        this.modelSettingsDialog.onUpdateLanguageVersion(e -> this.notifyUpdateLanguageVersion());
        this.executionTrigger.onExecute(e -> this.openExecutionLauncher());
    }

    public void refresh() {
        super.refresh();
        this.contentBlock.visible(this.model != null);
        if (!this.contentBlock.isVisible()) {
            return;
        }
        Project project = ((EditorBox)this.box()).projectManager().find(this.model);
        Language language = ((EditorBox)this.box()).languageManager().get(this.model);
        this.projectModelSelector.readonly(project == null);
        this.titleViewer.model(this.model);
        this.titleViewer.refresh();
        this.refreshReleaseSelector();
        this.checkTrigger.visible(this.release == null || this.release.equals(this.translate("draft")));
        this.checkTrigger.readonly(!PermissionsHelper.canCheck(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.commitTrigger.visible(!this.model.isTemplate() && (this.release == null || this.release.equals(this.translate("draft"))));
        this.commitTrigger.readonly(!PermissionsHelper.canCommit(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.infoTrigger.visible(!this.model.isTemplate());
        this.infoTrigger.readonly(!PermissionsHelper.canEditSettings(this.model, this.release, this.session()));
        this.forgeTrigger.visible(!this.model.isTemplate() && this.release != null && !this.release.equals("draft") && this.model.language().artifactId().equals("metta"));
        this.forgeTrigger.readonly(!PermissionsHelper.canForge(this.model, language, this.release, this.session()));
        if (this.forgeTrigger.isVisible()) {
            this.forgeTrigger.site(PathHelper.forgeUrl(this.model, this.release, this.session()));
        }
        this.executionTrigger.visible(!this.model.isTemplate() && this.release != null && !this.release.equals("draft") && !this.model.language().artifactId().equals("metta"));
        this.executionTrigger.readonly(!PermissionsHelper.canLaunchExecution(this.model, language, this.release, this.session()));
        this.downloadTrigger.visible(ModelHelper.validReleaseName(this.release, arg_0 -> ((ModelHeaderTemplate)this).translate(arg_0)));
        this.cloneTrigger.visible(!this.model.isTemplate());
        this.cloneTrigger.readonly(!PermissionsHelper.canClone(this.model, this.release, this.session(), (EditorBox)this.box()));
        this.languageLogo.visible(language != null);
        if (this.languageLogo.isVisible()) {
            this.languageLogo.value(LanguageHelper.logo(language, (EditorBox)this.box()));
        }
        this.helpTrigger.visible(language != null);
        this.languageTrigger.visible(language != null);
        if (language == null) {
            return;
        }
        this.helpTrigger.site(PathHelper.languageReleaseHelp(language, this.model.language().version()));
        this.languageTrigger.title(LanguageHelper.title(this.model.language()));
        this.languageTrigger.site(PathHelper.languageUrl(language, this.session()));
    }

    private void refreshReleaseSelector() {
        this.releaseSelector.visible(!this.model.isTemplate());
        if (!this.releaseSelector.isVisible()) {
            return;
        }
        this.releaseSelector.clear();
        SequencedCollection options = new ArrayList<String>(((EditorBox)this.box()).modelManager().releases(this.model)).reversed();
        options.addFirst(this.translate("draft"));
        this.releaseSelector.options((List)options);
        this.releaseSelector.option(this.release);
    }

    private void openRelease(String release) {
        String releaseName = release.equals(this.translate("draft")) ? "draft" : release;
        ((TemplateNotifier)this.notifier).dispatch(PathHelper.modelPath(this.model, releaseName, this.file));
    }

    private void check() {
        this.checkListener.accept(this.model);
    }

    private void commit() {
        this.commitModelDialog.model(this.model);
        this.commitModelDialog.open();
    }

    private void cloneModel() {
        this.cloneListener.accept(this.model);
    }

    private void openDownloadDialog() {
        this.downloadModelDialog.model(this.model);
        this.downloadModelDialog.release(this.release);
        this.downloadModelDialog.open();
    }

    private void openSettingsDialog() {
        this.modelSettingsDialog.model(this.model);
        this.modelSettingsDialog.open();
    }

    private void openExecutionLauncher() {
        this.executionLauncher.model(this.model);
        this.executionLauncher.release(this.release);
        this.executionLauncher.launch();
    }

    private void notifyUpdateLanguageVersion() {
        this.updateLanguageVersionListener.accept(this.model);
        this.refresh();
    }
}

