/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays;

import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRouteDispatcher
implements DisplayRouteDispatcher {
    private static Map<String, String> patterns = new HashMap<String, String>();

    public AbstractRouteDispatcher() {
        this.registerPatterns();
    }

    public void dispatch(Soul soul, String address) {
        address = address.replaceFirst(soul.session().browser().basePath(), "");
        List<String> params = this.paramsOf(address);
        if ((address = this.addressWithoutQueryString(address)).length() <= 1) {
            this.dispatchHome(soul, params.size() > 0 ? params.get(0) : null);
            return;
        }
        if (address.matches(patterns.get("home"))) {
            this.dispatchHome(soul, params.size() > 0 ? params.get(0) : null);
            return;
        }
        if (address.matches(patterns.get("about"))) {
            this.dispatchAbout(soul);
            return;
        }
        if (address.matches(patterns.get("language"))) {
            this.dispatchLanguage(soul, params.get(0), params.size() > 1 ? params.get(1) : null, params.size() > 2 ? params.get(2) : null);
            return;
        }
        if (address.matches(patterns.get("languageReleaseHelp"))) {
            this.dispatchLanguageReleaseHelp(soul, params.get(0), params.size() > 1 ? params.get(1) : null);
            return;
        }
        if (address.matches(patterns.get("languageReleaseTemplate"))) {
            this.dispatchLanguageReleaseTemplate(soul, params.get(0), params.size() > 1 ? params.get(1) : null);
            return;
        }
        if (address.matches(patterns.get("model"))) {
            this.dispatchModel(soul, params.get(0), params.get(1), params.size() > 2 ? params.get(2) : null, params.size() > 3 ? params.get(3) : null, params.size() > 4 ? params.get(4) : null, params.size() > 5 ? params.get(5) : null);
            return;
        }
        if (address.matches(patterns.get("startingModel"))) {
            this.dispatchStartingModel(soul, params.get(0), params.get(1));
            return;
        }
        if (address.matches(patterns.get("forge"))) {
            this.dispatchForge(soul, params.get(0), params.get(1), params.size() > 2 ? params.get(2) : null);
            return;
        }
        if (address.matches(patterns.get("login"))) {
            this.dispatchLogin(soul);
            return;
        }
    }

    public abstract void dispatchHome(Soul var1, String var2);

    public abstract void dispatchAbout(Soul var1);

    public abstract void dispatchLanguage(Soul var1, String var2, String var3, String var4);

    public abstract void dispatchLanguageReleaseHelp(Soul var1, String var2, String var3);

    public abstract void dispatchLanguageReleaseTemplate(Soul var1, String var2, String var3);

    public abstract void dispatchModel(Soul var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract void dispatchStartingModel(Soul var1, String var2, String var3);

    public abstract void dispatchForge(Soul var1, String var2, String var3, String var4);

    public abstract void dispatchLogin(Soul var1);

    private void registerPatterns() {
        if (patterns.size() > 0) {
            return;
        }
        patterns.put("home", "");
        patterns.put("about", "\\/about");
        patterns.put("language", "\\/models\\/([^\\/]*)");
        patterns.put("languageReleaseHelp", "\\/models\\/([^\\/]*)\\/help");
        patterns.put("languageReleaseTemplate", "\\/models\\/([^\\/]*)\\/template");
        patterns.put("model", "\\/models\\/([^\\/]*)\\/([^\\/]*)");
        patterns.put("startingModel", "\\/models\\/([^\\/]*)\\/([^\\/]*)\\/starting");
        patterns.put("forge", "\\/forge\\/([^\\/]*)\\/([^\\/]*)");
        patterns.put("login", "\\/login");
    }

    private String patternOf(String address) {
        String addressPart = this.addressWithoutQueryString(address);
        if (addressPart.equals("/") || addressPart.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (addressPart.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (addressPart.matches(patterns.get("about"))) {
            return patterns.get("about");
        }
        if (addressPart.matches(patterns.get("language"))) {
            return patterns.get("language");
        }
        if (addressPart.matches(patterns.get("languageReleaseHelp"))) {
            return patterns.get("languageReleaseHelp");
        }
        if (addressPart.matches(patterns.get("languageReleaseTemplate"))) {
            return patterns.get("languageReleaseTemplate");
        }
        if (addressPart.matches(patterns.get("model"))) {
            return patterns.get("model");
        }
        if (addressPart.matches(patterns.get("startingModel"))) {
            return patterns.get("startingModel");
        }
        if (addressPart.matches(patterns.get("forge"))) {
            return patterns.get("forge");
        }
        if (addressPart.matches(patterns.get("login"))) {
            return patterns.get("login");
        }
        return null;
    }

    private List<String> paramsOf(String address) {
        return this.paramsOf(address, this.patternOf(address));
    }

    private List<String> paramsOf(String address, String pattern) {
        if (pattern == null) {
            return Collections.emptyList();
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(address);
        if (!m.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i).split("\\?")[0]);
        }
        return this.addQueryStringParams(address, result);
    }

    private List<String> addQueryStringParams(String address, List<String> result) {
        if (address.indexOf("?") == -1) {
            return result;
        }
        String[] parameters = address.split("\\?")[1].split("&");
        for (int i = 0; i < parameters.length; ++i) {
            String[] split = parameters[i].split("=");
            result.add(split.length > 1 ? split[1] : "");
        }
        return result;
    }

    private String addressWithoutQueryString(String address) {
        return address.indexOf("?") != -1 ? address.substring(0, address.indexOf("?")) : address;
    }
}

