/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.languages.artifactories;

import io.intino.alexandria.logger.Logger;
import io.quassar.archetype.Archetype;
import io.quassar.editor.box.languages.LanguageArtifactory;
import io.quassar.editor.box.languages.MetamodelProvider;
import io.quassar.editor.box.util.Formatters;
import io.quassar.editor.box.util.StringHelper;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.tuple.Pair;

public class RemoteLanguageArtifactory
implements LanguageArtifactory {
    private final URL artifactory;
    private final Archetype archetype;
    private final MetamodelProvider metamodelProvider;
    private final Pair<String, String> credential;

    public RemoteLanguageArtifactory(URL artifactory, Archetype archetype, MetamodelProvider provider, Pair<String, String> credential) {
        this.artifactory = artifactory;
        this.archetype = archetype;
        this.metamodelProvider = provider;
        this.credential = credential;
    }

    @Override
    public File retrieve(GavCoordinates gav) throws IOException {
        return this.download(gav);
    }

    @Override
    public String mainClass(GavCoordinates gav) {
        Model model = this.metamodelProvider.provide(gav.languageId());
        if (model == null) {
            return gav.groupId() + "." + Formatters.firstUpperCase(StringHelper.kebabCaseToCamelCase(gav.artifactId()));
        }
        return "tara.dsl." + Formatters.firstUpperCase(StringHelper.kebabCaseToCamelCase(model.name()));
    }

    public File download(GavCoordinates gav) throws IOException {
        String filename = gav.artifactId() + "-" + gav.version().toLowerCase() + ".jar";
        File file = this.archetype.languages().releaseDslJar(gav.languageId(), gav.version());
        if (file.exists()) {
            return file;
        }
        URL url = URI.create(String.join((CharSequence)"/", this.artifactory.toString(), gav.groupId(), gav.artifactId(), gav.version(), filename)).toURL();
        Files.write(file.toPath(), this.connect(url).readAllBytes(), new OpenOption[0]);
        return file;
    }

    private InputStream connect(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            if (this.credential != null) {
                String auth = (String)this.credential.getKey() + ":" + (String)this.credential.getValue();
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
                String authHeaderValue = "Basic " + new String(encodedAuth);
                connection.setRequestProperty("Authorization", authHeaderValue);
                return connection.getInputStream();
            }
            return this.openConnection(url);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private InputStream openConnection(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            return connection.getInputStream();
        }
        catch (Throwable e) {
            return InputStream.nullInputStream();
        }
    }
}

