/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.languages;

import io.intino.alexandria.logger.Logger;
import io.intino.ls.IntinoLanguageServer;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class LanguageServerWebSocketHandler
implements WebSocketListener {
    public static final int MessageSize = 1000000;
    private final Function<Session, LanguageServer> provider;
    private ExecutorService executorService;
    private PipedOutputStream clientOutput;
    private PipedInputStream serverInput;
    private final Object monitor = new Object();

    public LanguageServerWebSocketHandler(Function<Session, LanguageServer> provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketConnect(Session session) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                session.setIdleTimeout(Duration.ofDays(1L));
                session.setMaxTextMessageSize(1000000L);
                PipedInputStream clientInput = new PipedInputStream(1000000);
                this.clientOutput = new PipedOutputStream(clientInput);
                this.serverInput = new PipedInputStream(1000000);
                PipedOutputStream out = new PipedOutputStream(this.serverInput);
                this.executorService = Executors.newSingleThreadExecutor();
                this.executorService.submit(() -> this.notificationThread(session));
                IntinoLanguageServer server = (IntinoLanguageServer)this.provider.apply(session);
                Launcher serverLauncher = LSPLauncher.createServerLauncher((LanguageServer)server, (InputStream)clientInput, (OutputStream)out);
                server.connect((LanguageClient)serverLauncher.getRemoteProxy());
                serverLauncher.startListening();
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public void onWebSocketText(String message) {
        try {
            String content = "Content-Length: " + message.getBytes().length + "\n\n" + message;
            this.clientOutput.write(content.getBytes());
            this.clientOutput.flush();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(int statusCode, String reason) {
        Object object = this.monitor;
        synchronized (object) {
            this.executorService.shutdown();
        }
    }

    private void notificationThread(Session session) {
        try {
            int bytesRead;
            byte[] buffer = new byte[8096];
            while ((bytesRead = this.serverInput.read(buffer)) != -1) {
                String content = new String(buffer, 0, bytesRead);
                content = content.replaceAll("Content-Length: [0-9+]*", "").trim();
                for (String message : content.split("\r?\n")) {
                    if (message.isEmpty()) continue;
                    session.getRemote().sendString(message.trim());
                }
            }
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }
}

