/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.builder;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.QuassarBuilderServiceAccessor;
import io.intino.builderservice.schemas.Message;
import io.intino.builderservice.schemas.OperationResult;
import io.intino.builderservice.schemas.RunOperationContext;
import io.intino.ls.document.DocumentManager;
import io.intino.ls.document.FileDocumentManager;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.builder.BuildResult;
import io.quassar.editor.box.builder.CheckResult;
import io.quassar.editor.box.util.Formatters;
import io.quassar.editor.box.util.TarUtils;
import io.quassar.editor.model.GavCoordinates;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.Model;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class ModelBuilder {
    private final Model model;
    private final GavCoordinates destination;
    private final Language language;
    private final File languagePath;
    private final DocumentManager manager;
    private final QuassarBuilderServiceAccessor accessor;
    private final String quassarBuilder;
    private static final String CheckOperation = "Check";
    private static final String BuildOperation = "Build";

    public ModelBuilder(Model model, GavCoordinates destination, EditorBox box) throws IOException {
        this.model = model;
        this.destination = destination;
        this.language = box.languageManager().get(model.language());
        this.languagePath = box.languageManager().loadDsl(model.language());
        this.quassarBuilder = box.configuration().quassarBuilder();
        this.manager = new FileDocumentManager(box.modelManager().workspace(model, "draft").root());
        this.accessor = box.builderAccessor();
    }

    public CheckResult check(String user) {
        return this.run(CheckOperation);
    }

    public BuildResult build(String user) throws InternalServerError, NotFound {
        CheckResult result = this.run(BuildOperation);
        if (!result.success()) {
            return BuildResult.failure(result.messages());
        }
        this.manager.commit(user);
        this.manager.push();
        return BuildResult.success(result.messages(), this.artifacts(result));
    }

    private Resource artifacts(CheckResult result) throws InternalServerError, NotFound {
        OperationResult output = this.accessor.getOperationOutput(result.ticket());
        return output.buildRef() != null ? this.accessor.getOutputResource(result.ticket(), QuassarBuilderServiceAccessor.OutputResourceOutput.Build, null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckResult run(String operation) {
        File taraFiles = null;
        try {
            taraFiles = this.taraFiles();
            if (taraFiles == null) {
                CheckResult checkResult = CheckResult.failure(new Message().kind(Message.Kind.ERROR).content("Model files not found"));
                return checkResult;
            }
            CheckResult checkResult = this.doRun(taraFiles, operation);
            return checkResult;
        }
        catch (Throwable t) {
            Logger.error((Throwable)t);
            CheckResult checkResult = CheckResult.failure(new Message().kind(Message.Kind.ERROR).content("Unknown error"));
            return checkResult;
        }
        finally {
            if (taraFiles != null) {
                taraFiles.delete();
            }
        }
    }

    private CheckResult doRun(File taraFiles, String operation) throws InternalServerError, IOException, NotFound, InterruptedException, URISyntaxException {
        String ticket = this.accessor.postRunOperation(this.context(this.quassarBuilder).operation(operation), Resource.InputStreamProvider.of((File)taraFiles));
        OperationResult output = this.accessor.getOperationOutput(ticket);
        while (output.state() == OperationResult.State.Running) {
            Thread.sleep(1000L);
            output = this.accessor.getOperationOutput(ticket);
        }
        return output.success() != false ? CheckResult.success(ticket, output.messages()) : CheckResult.failure(ticket, output.messages());
    }

    private File taraFiles() {
        try {
            List<URI> uris = this.modelUris();
            if (uris.isEmpty()) {
                return null;
            }
            return TarUtils.createTarFile(this.manager, uris, Files.createTempFile("quassar", ".tar", new FileAttribute[0]).toFile());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private List<URI> modelUris() {
        return this.manager.all().stream().filter(l -> l.getPath().endsWith(this.langExtension())).toList();
    }

    private String langExtension() {
        return ".tara".toLowerCase();
    }

    private RunOperationContext context(String builder) {
        return new RunOperationContext().imageURL(builder).generationPackage("").languageGroup(this.language.group()).languageName(Formatters.normalizeLanguageName(this.language.name())).languageVersion(this.model.language().version()).languagePath(this.languagePath.getAbsolutePath()).projectGroup(this.destination.groupId()).projectName(Formatters.normalizeLanguageName(this.destination.artifactId())).projectVersion(this.destination.version());
    }
}

