/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.model;

import io.quassar.editor.box.util.SubjectHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import systems.intino.datamarts.subjectstore.model.Subject;

public class SubjectWrapper {
    protected final transient Subject subject;
    private final Map<String, String> cache = new HashMap<String, String>();
    private final Map<String, List<String>> listCache = new HashMap<String, List<String>>();

    public SubjectWrapper(Subject subject) {
        this.subject = subject;
    }

    protected List<String> getList(String name) {
        if (this.listCache.containsKey(name)) {
            return this.listCache.get(name);
        }
        ArrayList<String> result = new ArrayList<String>(SubjectHelper.terms(this.subject, name));
        this.listCache.put(name, result);
        return result;
    }

    protected String getOrEmpty(String name) {
        return this.get(name) != null ? this.get(name) : "";
    }

    protected String get(String name) {
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        List<String> terms = SubjectHelper.terms(this.subject, name);
        this.cache.put(name, !terms.isEmpty() ? terms.getFirst() : null);
        return this.cache.get(name);
    }

    protected void set(String name, String value) {
        this.cache.remove(name);
        if (value == null) {
            return;
        }
        this.subject.update().set(name, value);
    }

    protected void put(String name, String value) {
        this.cache.remove(name);
        this.subject.update().put(name, value);
    }

    protected void putList(String name, List<String> values) {
        this.listCache.remove(name);
        Subject.Updating updating = this.subject.update();
        updating.del(name);
        values.forEach(v -> updating.put(name, v));
    }
}

