/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.util;

import io.intino.alexandria.ui.services.push.UISession;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.ui.types.LandingDialog;
import io.quassar.editor.box.ui.types.LanguageTab;
import io.quassar.editor.box.ui.types.LanguageView;
import io.quassar.editor.box.ui.types.LanguagesTab;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.model.FilePosition;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import io.quassar.editor.model.Model;

public class PathHelper {
    private static final String ModelPath = "/models/:language/:model";
    private static final String LanguageReleaseHelpPath = "/models/:language/help";
    private static final String ForgePath = "/forge/:model/:release";

    public static String homeUrl(UISession session) {
        return session.browser().baseUrl();
    }

    public static String aboutUrl(UISession session) {
        return session.browser().baseUrl() + "/about";
    }

    public static String homePath() {
        return "/";
    }

    public static String downloadModelUrl(Model model, String release, UISession session) {
        return session.browser().baseUrl() + "/downloads/%s/%s".formatted(model.id(), release);
    }

    public static String downloadModelFileUrl(Model model, String release, File file, UISession session) {
        return session.browser().baseUrl() + "/downloads/%s/%s/%s".formatted(model.id(), release, file.uri());
    }

    public static String landingUrl(LandingDialog dialog, UISession session) {
        return PathHelper.homeUrl(session) + "?dialog=" + dialog.name().toLowerCase();
    }

    public static String landingPath(String path, LandingDialog dialog) {
        return path + (String)(dialog != null ? "?dialog=" + dialog.name().toLowerCase() : "");
    }

    public static String permissionsUrl(Language language, String callbackUrl, UISession session) {
        return session.browser().baseUrl() + "/permissions?language=" + language.key() + "&callback=" + callbackUrl;
    }

    public static String permissionsUrl(Model model, String callbackUrl, UISession session) {
        return session.browser().baseUrl() + "/permissions?model=" + model.id() + "&callback=" + callbackUrl;
    }

    public static String notFoundUrl(String type, UISession session) {
        return session.browser().baseUrl() + "/not-found?type=" + type;
    }

    public static String loginUrl(UISession session) {
        return session.browser().baseUrl() + "/login";
    }

    public static String languagesUrl(UISession session) {
        return PathHelper.homeUrl(session);
    }

    public static String languagesPath(String address, LanguagesTab tab) {
        return address + "?tab=" + (tab != null ? tab.name().toLowerCase() : LanguagesTab.PublicLanguages.name().toLowerCase());
    }

    public static String languageUrl(Language language, UISession session) {
        return session.browser().baseUrl() + "/models/" + language.name();
    }

    public static String languageUrl(String language, UISession session) {
        return session.browser().baseUrl() + "/models/" + language;
    }

    public static String languagePath(Language language) {
        return PathHelper.languagePath("/models/:language", language.key(), null, null);
    }

    public static String languagePath(String language) {
        return PathHelper.languagePath("/models/:language", language, null, null);
    }

    public static String languagePath(String address, Language language) {
        return PathHelper.languagePath(address, language.key(), null, null);
    }

    public static String languagePath(String address, String language) {
        return PathHelper.languagePath(address, language, null, null);
    }

    public static String languagePath(String address, String language, LanguageTab tab, LanguageView view) {
        Object result = address.replace(":language", language);
        result = (String)result + (String)(tab != null ? (((String)result).contains("?") ? "&" : "?") + "tab=" + tab.name().toLowerCase() : "");
        result = (String)result + (String)(view != null ? (((String)result).contains("?") ? "&" : "?") + "view=" + view.name().toLowerCase() : "");
        return result;
    }

    public static String languagePath(String address, Language language, LanguageTab tab) {
        return PathHelper.languagePath(address, language.key(), tab, null);
    }

    public static String languagePath(String address, Language language, LanguageTab tab, LanguageView view) {
        return PathHelper.languagePath(address, language.key(), tab, view);
    }

    public static String modelUrl(Model model, UISession session) {
        return PathHelper.modelUrl(model, null, session);
    }

    public static String modelUrl(Model model, String release, UISession session) {
        return session.browser().baseUrl() + "/models/" + model.id() + (String)(release != null ? "?release=" + release : "");
    }

    public static String modelPath(Model model) {
        return PathHelper.modelPath(ModelPath, model, null, null, null, null);
    }

    public static String startingModelPath(Model model) {
        return PathHelper.modelPath(model) + "/starting";
    }

    public static String modelTemplateUrl(Model model, UISession session) {
        return session.browser().baseUrl() + PathHelper.modelPath(model) + "/template";
    }

    public static String modelPath(Model model, String release) {
        return PathHelper.modelPath(ModelPath, model, release, null, null, null);
    }

    public static String modelPath(Model model, String release, ModelView view, String file) {
        return PathHelper.modelPath(ModelPath, model, release, view, file, null);
    }

    public static String modelPath(Model model, String release, File file) {
        return PathHelper.modelPath(ModelPath, model, release, null, file != null ? file.uri() : null, null);
    }

    public static String modelPath(Model model, String release, File file, FilePosition position) {
        return PathHelper.modelPath(ModelPath, model, release, null, file != null ? file.uri() : null, position);
    }

    public static String modelPath(String address, Model model) {
        return PathHelper.modelPath(address, model, null, null, null, null);
    }

    public static String modelPath(String address, Model model, String release, String file, FilePosition position) {
        ModelView view = file != null && File.isResource(file) ? ModelView.Resources : ModelView.Model;
        return PathHelper.modelPath(address, model, release, view, file, position);
    }

    public static String modelUrl(String language, String model, String release, String view, String file, String position, UISession session) {
        return PathHelper.modelPath(session.browser().baseUrl() + ModelPath, language, model, release, view, file, position);
    }

    public static String modelPath(String address, Model model, String release, ModelView view, String file, FilePosition position) {
        return PathHelper.modelPath(address, model.language().artifactId(), model.id(), release, view != null ? view.name() : null, file, position != null ? position.line() + "-" + position.column() : null);
    }

    public static String modelPath(String address, String language, String model, String release, String view, String file, String position) {
        Object result = address.replace(":language", language).replace(":model", model);
        result = (String)result + (String)(release != null ? "?release=" + release : "");
        result = (String)result + (String)(view != null ? (((String)result).contains("?") ? "&" : "?") + "view=" + view : "");
        result = (String)result + (String)(file != null ? (((String)result).contains("?") ? "&" : "?") + "file=" + file : "");
        result = (String)result + (String)(position != null ? (((String)result).contains("?") ? "&" : "?") + "pos=" + position : "");
        return result;
    }

    public static String modelViewPath(String address, Model model, String release) {
        Object result = address.replace(":language", model.language().artifactId()).replace(":model", model.id());
        result = (String)result + (String)(release != null ? "?release=" + release : "");
        result = (String)result + (((String)result).contains("?") ? "&" : "?") + "view=:view";
        return result;
    }

    public static String languageReleaseHelp(String address, Language language, LanguageRelease release) {
        return PathHelper.languageReleaseHelp(address, language, release.version());
    }

    public static String languageReleaseHelp(String address, Language language, String release) {
        return address.replace(":language", language.key()) + "?version=" + release;
    }

    public static String languageReleaseHelp(Language language, LanguageRelease release) {
        return PathHelper.languageReleaseHelp(LanguageReleaseHelpPath, language, release);
    }

    public static String languageReleaseHelp(Language language, String release) {
        return PathHelper.languageReleaseHelp(LanguageReleaseHelpPath, language, release);
    }

    public static String forgeUrl(Model model, String release, UISession session) {
        return session.browser().baseUrl() + ForgePath.replace(":model", model.id()).replace(":release", release);
    }

    public static String forgePath(String address, String model, String release) {
        Object result = address.replace(":model", model).replace(":release", release);
        result = (String)result + "?view=:view";
        return result;
    }

    public static String forgeReleasePath(String address, String model, String view) {
        Object result = address.replace(":model", model);
        result = (String)result + "?" + "view=%s".formatted(view);
        return result;
    }
}

