/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.users;

import io.intino.alexandria.logger.Logger;
import io.quassar.archetype.Archetype;
import io.quassar.editor.box.util.SubjectHelper;
import io.quassar.editor.model.User;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import systems.intino.datamarts.subjectstore.SubjectStore;
import systems.intino.datamarts.subjectstore.model.Subject;

public class UserManager {
    private final Archetype archetype;
    private final SubjectStore subjectStore;

    public UserManager(Archetype archetype, SubjectStore store) {
        this.archetype = archetype;
        this.subjectStore = store;
    }

    public List<User> users() {
        return this.subjectStore.subjects().type("user").isRoot().collect().stream().map(this::get).toList();
    }

    public boolean exists(String key) {
        return this.get(key) != null;
    }

    public User get(String key) {
        Subject subject = this.subjectStore.open(SubjectHelper.userPath(key));
        if (subject == null || subject.isNull()) {
            subject = this.subjectStore.subjects().type("user").where("name").equals(key).collect().stream().findFirst().orElse(null);
        }
        return this.get(subject);
    }

    public User create(String id, String name) {
        User user = new User(this.subjectStore.create(SubjectHelper.userPath(id)));
        user.id(id);
        user.name(name);
        return user;
    }

    public void remove(User user) {
        try {
            File rootDir = this.archetype.users().user(user.name());
            if (!rootDir.exists()) {
                return;
            }
            this.subjectStore.open(SubjectHelper.pathOf(user)).drop();
            FileUtils.deleteDirectory((File)rootDir);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private User get(Subject subject) {
        if (subject == null || subject.isNull()) {
            return null;
        }
        return new User(subject);
    }
}

