/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.DisplayRepository;
import io.intino.alexandria.ui.displays.DisplayRouter;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;
import io.intino.alexandria.ui.server.pages.UiPage;
import io.intino.alexandria.ui.server.resources.Resource;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.services.push.UIClient;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.RouteDispatcher;
import io.quassar.editor.box.ui.pages.ModelPage;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class ModelResource
extends Resource {
    private final EditorBox box;

    public ModelResource(EditorBox box, AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    public void execute() throws AlexandriaException {
        super.execute();
        this.fillDeviceParameter();
        this.render();
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        ModelPage page = new ModelPage();
        ((UiPage)page).session = this.manager.currentSession();
        ((UiPage)page).session.browser().onRedirect(location -> this.manager.redirect(location));
        ((UiPage)page).session.browser().requestUrl(this.manager.requestUrl());
        ((UiPage)page).session.whenLogin((Function)new Function<String, String>(){
            final /* synthetic */ UiPage val$page;
            {
                this.val$page = uiPage;
            }

            @Override
            public String apply(String baseUrl) {
                return ModelResource.this.authenticate(this.val$page.session, baseUrl);
            }
        });
        ((UiPage)page).session.whenLogout(arg_0 -> this.lambda$render$1((UiPage)page, arg_0));
        page.box = this.box;
        ((UiPage)page).clientId = clientId;
        ((UiPage)page).webDirectories = this.manager.webDirectories();
        ((UiPage)page).device = this.parameterValue("device");
        ((UiPage)page).token = this.parameterValue("token");
        page.language = this.parameterValue("language");
        page.model = this.parameterValue("model");
        page.release = this.parameterValue("release");
        page.view = this.parameterValue("view");
        page.file = this.parameterValue("file");
        page.pos = this.parameterValue("pos");
        if (!page.hasPermissions()) {
            this.manager.redirect(page.redirectUrl());
            return;
        }
        ((PushService)this.manager.pushService()).onOpen(arg_0 -> this.lambda$render$5((UiPage)page, clientId, arg_0));
        ((PushService)this.manager.pushService()).onClose(clientId).execute((Consumer)new Consumer<UIClient>(){

            @Override
            public void accept(UIClient client) {
                ModelResource.this.box.soul(client.id()).ifPresent(s -> s.destroy());
                ModelResource.this.box.unRegisterSoul(client.id());
                ModelResource.this.manager.unRegister(client);
            }
        });
        this.manager.write((Object)page.execute());
    }

    private /* synthetic */ Boolean lambda$render$5(UiPage page, String clientId, UIClient client) {
        if (!client.id().equals(page.clientId)) {
            return false;
        }
        if (client.soul() != null && this.box.routeManager().routeDispatcher() instanceof RouteDispatcher) {
            ((RouteDispatcher)this.box.routeManager().routeDispatcher()).dispatchModel(client.soul(), ((ModelPage)page).language, ((ModelPage)page).model, ((ModelPage)page).release, ((ModelPage)page).view, ((ModelPage)page).file, ((ModelPage)page).pos);
            return false;
        }
        Soul soul = page.prepareSoul(client);
        soul.onRedirect(location -> this.manager.redirect(location));
        soul.addRegisterDisplayListener(display -> {
            display.inject(this.notifier(page.session, client, (Display)display));
            display.inject(page.session);
            display.inject((DisplayRepository)soul);
            display.inject(() -> soul);
        });
        client.soul(soul);
        client.cookies(this.manager.cookies());
        this.box.registerSoul(clientId, soul);
        soul.register(new DisplayRouter((AlexandriaUiBox)this.box).id("__router__"));
        if (this.box.routeManager().routeDispatcher() instanceof RouteDispatcher) {
            ((RouteDispatcher)this.box.routeManager().routeDispatcher()).dispatchModel(soul, ((ModelPage)page).language, ((ModelPage)page).model, ((ModelPage)page).release, ((ModelPage)page).view, ((ModelPage)page).file, ((ModelPage)page).pos);
        }
        return true;
    }

    private /* synthetic */ void lambda$render$1(UiPage page, Boolean b) {
        this.logout(page.session);
    }
}

