/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.FileEditable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.ModelCommands;
import io.quassar.editor.box.models.File;
import io.quassar.editor.box.models.ModelContainer;
import io.quassar.editor.box.schemas.IntinoFileBrowserItem;
import io.quassar.editor.box.schemas.IntinoFileBrowserOperation;
import io.quassar.editor.box.schemas.IntinoFileBrowserOperationShortcut;
import io.quassar.editor.box.ui.displays.IntinoFileBrowser;
import io.quassar.editor.box.ui.displays.templates.AbstractModelBrowserTemplate;
import io.quassar.editor.box.ui.types.ModelView;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.IntinoFileBrowserHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.box.util.PermissionsHelper;
import io.quassar.editor.model.Model;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class ModelBrowserTemplate
extends AbstractModelBrowserTemplate<EditorBox> {
    private Model model;
    private String release;
    private ModelContainer modelContainer;
    private File file;
    private Operation operation;
    private Consumer<IntinoFileBrowserItem> openListener;
    private Consumer<File> changeListener;
    private Consumer<File> removeListener;

    public ModelBrowserTemplate(EditorBox box) {
        super(box);
    }

    public void model(Model value) {
        this.model = value;
    }

    public void release(String value) {
        this.release = value;
    }

    public void modelContainer(ModelContainer value) {
        this.modelContainer = value;
    }

    public void file(File value) {
        this.file = value;
    }

    public void selection(String uri) {
        this.file = this.modelContainer.file(uri);
        ((IntinoFileBrowser)this.fileBrowser.display()).select(IntinoFileBrowserHelper.itemOf(this.file));
    }

    public void onOpen(Consumer<IntinoFileBrowserItem> listener) {
        this.openListener = listener;
    }

    public void onChange(Consumer<File> listener) {
        this.changeListener = listener;
    }

    public void onRemove(Consumer<File> listener) {
        this.removeListener = listener;
    }

    public void didMount() {
        super.didMount();
        this.createBrowser();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.operationsTrigger.onExecute(e -> this.openBrowserContextMenu());
        this.addFile.onExecute(e -> this.executeFileDialogOperation());
        this.fileDialog.onOpen(e -> this.refreshFileDialog());
        this.removeFileTrigger.onExecute(e -> this.removeFile());
        this.fileField.onChange(e -> this.addFile.readonly(e.value() == null || ((String)e.value()).isEmpty()));
        this.fileField.onEnterPress(e -> this.executeFileDialogOperation());
        this.addFileField.onChange(this::addFile);
        this.createBrowser();
    }

    public void refresh() {
        super.refresh();
        if (this.model == null) {
            return;
        }
        IntinoFileBrowser browser = (IntinoFileBrowser)this.fileBrowser.display();
        browser.itemAddress(PathHelper.modelPath(this.model, this.release) + "&file=:file");
        browser.items(IntinoFileBrowserHelper.fileBrowserItems(this.modelContainer.modelFiles()), true, true);
        browser.operations(this.operations());
        browser.selection(this.file != null ? IntinoFileBrowserHelper.itemOf(this.file) : null);
        browser.refresh();
        this.addFileField.readonly(!PermissionsHelper.canEdit(this.model, this.release, this.session()));
        this.addFileField.allowedTypesByName(List.of(FileEditable.Type.Text.name(), FileEditable.Type.Zip.name(), ".tara"));
    }

    private void createBrowser() {
        IntinoFileBrowser browser = new IntinoFileBrowser((EditorBox)this.box());
        browser.onOpen(f -> this.openListener.accept((IntinoFileBrowserItem)f));
        browser.onExecuteOperation(this::execute);
        browser.onRename(this::rename);
        browser.onMove(this::move);
        this.fileBrowser.clear();
        this.fileBrowser.display(browser);
    }

    private void openBrowserContextMenu() {
        ((IntinoFileBrowser)this.fileBrowser.display()).openContextMenu(this.operations());
    }

    private List<IntinoFileBrowserOperation> operations() {
        if (this.model == null) {
            return Collections.emptyList();
        }
        return List.of(new IntinoFileBrowserOperation().name("Add model file...").shortcut(new IntinoFileBrowserOperationShortcut().ctrlKey(true).key("N")).enabled(PermissionsHelper.canEdit(this.model, this.release, this.session())), new IntinoFileBrowserOperation().name("Add folder...").shortcut(new IntinoFileBrowserOperationShortcut().shiftKey(true).ctrlKey(true).key("N")).enabled(PermissionsHelper.canEdit(this.model, this.release, this.session())), new IntinoFileBrowserOperation().name("Rename...").shortcut(new IntinoFileBrowserOperationShortcut().ctrlKey(true).key("R")).enabled(this.file != null && PermissionsHelper.canEdit(this.model, this.release, this.session())), new IntinoFileBrowserOperation().name("Remove").shortcut(new IntinoFileBrowserOperationShortcut().ctrlKey(true).key("Backspace")).enabled(this.file != null && PermissionsHelper.canEdit(this.model, this.release, this.session())));
    }

    private void execute(String operation, IntinoFileBrowserItem target) {
        if (operation.equalsIgnoreCase("add model file...")) {
            this.openFileDialog(Operation.AddFile);
        } else if (operation.equalsIgnoreCase("add folder...")) {
            this.openFileDialog(Operation.AddFolder);
        } else if (operation.equalsIgnoreCase("rename...")) {
            this.openFileDialog(Operation.EditFilename);
        } else if (operation.equalsIgnoreCase("remove")) {
            this.removeFileTrigger.launch();
        }
    }

    private void openFileDialog(Operation operation) {
        this.operation = operation;
        this.fileDialog.open();
    }

    private void refreshFileDialog(Operation operation) {
        this.operation = operation;
        this.refreshFileDialog();
    }

    private void refreshFileDialog() {
        if (this.operation == null) {
            return;
        }
        this.fileDialog.title(this.fileDialogTitle());
        this.fileField.value(this.operation == Operation.EditFilename ? this.nameOf(this.file) : null);
    }

    private String fileDialogTitle() {
        if (this.operation == Operation.CopyFile) {
            return this.translate("Copy model file");
        }
        if (this.operation == Operation.AddFolder) {
            return this.translate("Add model folder");
        }
        if (this.operation == Operation.EditFilename) {
            return this.translate("Edit model file name");
        }
        return this.translate("Add model file");
    }

    private void executeFileDialogOperation() {
        if (!DisplayHelper.check(this.fileField, arg_0 -> ((ModelBrowserTemplate)this).translate(arg_0))) {
            return;
        }
        this.fileDialog.close();
        if (this.operation == Operation.AddFile) {
            this.addFile();
        } else if (this.operation == Operation.CopyFile) {
            this.copyFile();
        } else if (this.operation == Operation.EditFilename) {
            this.rename();
        } else if (this.operation == Operation.AddFolder) {
            this.addFolder();
        }
    }

    private void addFile(ChangeEvent event) {
        try {
            Resource value = (Resource)event.value();
            if (value == null) {
                return;
            }
            if (ModelHelper.isZip(value.name())) {
                ((EditorBox)this.box()).commands(ModelCommands.class).addZip(this.model, ModelView.Model, value.stream(), this.file, this.username());
            } else {
                this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).createFile(this.model, this.withExtension(value.name()), value.stream(), this.file, this.username()));
            }
            this.refresh();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        finally {
            this.addFileField.value(null);
        }
    }

    private void addFile() {
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).createFile(this.model, this.withExtension(this.fileField.value()), null, this.file, this.username()));
    }

    private void copyFile() {
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).copy(this.model, this.fileField.value(), this.file, this.username()));
    }

    private void rename() {
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).rename(this.model, this.withExtension(this.fileField.value()), this.file, this.username()));
    }

    private void addFolder() {
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).createFolder(this.model, this.fileField.value(), this.file, this.username()));
    }

    private void removeFile() {
        ((EditorBox)this.box()).commands(ModelCommands.class).remove(this.model, this.file, this.username());
        this.removeListener.accept(null);
    }

    private void rename(IntinoFileBrowserItem item, String newName) {
        File file = this.modelContainer.file(item.uri());
        if (!((String)newName).endsWith(".tara")) {
            newName = (String)newName + ".tara";
        }
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).rename(this.model, (String)newName, file, this.username()));
    }

    private void move(IntinoFileBrowserItem item, IntinoFileBrowserItem directoryItem) {
        File file = this.modelContainer.file(item.uri());
        File directory = directoryItem != null ? this.modelContainer.file(directoryItem.uri()) : null;
        this.changeListener.accept(((EditorBox)this.box()).commands(ModelCommands.class).move(this.model, file, directory, this.username()));
    }

    private String nameOf(File file) {
        if (file == null) {
            return null;
        }
        if (!file.name().contains(".")) {
            return file.name();
        }
        return file.name().substring(0, file.name().lastIndexOf("."));
    }

    private String withExtension(String name) {
        String extension = ".tara";
        return name.endsWith(extension) ? name : name + extension;
    }

    private static enum Operation {
        CopyFile,
        AddFile,
        AddFolder,
        EditFilename;

    }
}

