/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageHelpTemplate;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageRelease;
import java.util.function.Consumer;

public class LanguageHelpTemplate
extends AbstractLanguageHelpTemplate<EditorBox> {
    private Language language;
    private String release;
    private Consumer<Command.CommandResult> createVersionListener;

    public LanguageHelpTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void onCreateVersion(Consumer<Command.CommandResult> listener) {
        this.createVersionListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.helpField.onChange(e -> this.saveHelp());
        this.createVersion.onExecute(e -> this.createVersion());
    }

    public void refresh() {
        super.refresh();
        LanguageRelease languageRelease = this.language.release(this.release);
        this.selectVersionBlock.visible(this.release == null);
        this.versionBlock.visible(this.release != null && languageRelease != null);
        this.versionNotCreatedBlock.visible(this.release != null && languageRelease == null);
        if (!this.versionBlock.isVisible()) {
            return;
        }
        this.helpField.value(((EditorBox)this.box()).languageManager().loadHelp(this.language, this.release));
    }

    private void saveHelp() {
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveHelp(this.language, this.release, this.helpField.value(), this.username());
    }

    private void createVersion() {
        this.notifyUser("Creating version...", UserMessage.Type.Loading);
        this.createVersion.readonly(true);
        this.createVersionListener.accept(((EditorBox)this.box()).commands(LanguageCommands.class).createRelease(this.language, this.release, this.username()));
        this.createVersion.readonly(false);
        this.hideUserNotification();
    }
}

