/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.UserMessage;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.commands.Command;
import io.quassar.editor.box.commands.LanguageCommands;
import io.quassar.editor.box.ui.displays.templates.AbstractLanguageExecutionTemplate;
import io.quassar.editor.box.util.Formatters;
import io.quassar.editor.model.Language;
import io.quassar.editor.model.LanguageExecution;
import io.quassar.editor.model.LanguageRelease;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

public class LanguageExecutionTemplate
extends AbstractLanguageExecutionTemplate<EditorBox> {
    private Language language;
    private String release;
    private Consumer<Command.CommandResult> createVersionListener;
    private static final List<String> Languages = List.of("Docker", "Maven", "Python", "Custom");

    public LanguageExecutionTemplate(EditorBox box) {
        super(box);
    }

    public void language(Language language) {
        this.language = language;
    }

    public void release(String release) {
        this.release = release;
    }

    public void onCreateVersion(Consumer<Command.CommandResult> listener) {
        this.createVersionListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.createVersion.onExecute(e -> this.createVersion());
        this.executionSelector.onSelect(e -> this.saveType());
        this.localEnvironmentBlock.onInit(e -> this.initLocalEnvironmentBlock());
        this.localEnvironmentBlock.onShow(e -> this.refreshLocalEnvironmentBlock());
        this.remoteEnvironmentBlock.onInit(e -> this.initRemoteEnvironmentBlock());
        this.remoteEnvironmentBlock.onShow(e -> this.refreshRemoteEnvironmentBlock());
    }

    public void refresh() {
        super.refresh();
        LanguageRelease languageRelease = this.language.release(this.release);
        this.selectVersionBlock.visible(this.release == null);
        this.versionBlock.visible(this.release != null && languageRelease != null);
        this.versionNotCreatedBlock.visible(this.release != null && languageRelease == null);
        if (languageRelease == null) {
            return;
        }
        LanguageExecution execution = this.execution();
        if (execution == null) {
            execution = ((EditorBox)this.box()).commands(LanguageCommands.class).createExecution(this.language, this.release, LanguageExecution.Type.None, this.username());
        }
        this.executionSelector.select(execution.type().name().toLowerCase() + "Option");
    }

    private void createVersion() {
        this.notifyUser("Creating version...", UserMessage.Type.Loading);
        this.createVersion.readonly(true);
        this.createVersionListener.accept(((EditorBox)this.box()).commands(LanguageCommands.class).createRelease(this.language, this.release, this.username()));
        this.createVersion.readonly(false);
        this.hideUserNotification();
    }

    private void saveType() {
        LanguageExecution execution;
        LanguageExecution.Type selected = this.selectedExecution();
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveExecution(this.language, this.release, selected, (execution = this.execution()) != null ? execution.content(selected) : "", this.username());
    }

    private LanguageExecution.Type selectedExecution() {
        List selection = this.executionSelector.selection();
        if (selection.isEmpty()) {
            return LanguageExecution.Type.None;
        }
        String selected = (String)selection.getFirst();
        return LanguageExecution.Type.valueOf(Formatters.firstUpperCase(selected).replace("Option", ""));
    }

    private void initLocalEnvironmentBlock() {
        this.localField.onChange(e -> this.saveLocalConfiguration((String)e.value()));
        this.insertTemplate.onExecute(e -> this.insertTemplate());
    }

    private void insertTemplate() {
        String selectedLanguage;
        String string = selectedLanguage = !this.templateSelector.selection().isEmpty() ? (String)this.templateSelector.selection().getFirst() : null;
        if (selectedLanguage == null) {
            return;
        }
        this.localField.value(this.templateContent(selectedLanguage));
        this.saveLocalConfiguration(this.localField.value());
        this.localField.focus();
    }

    private String templateContent(String language) {
        try {
            InputStream stream = LanguageExecutionTemplate.class.getResourceAsStream("/templates/execution/%s.tpl".formatted(language));
            if (stream == null) {
                return "";
            }
            return IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    private void refreshLocalEnvironmentBlock() {
        LanguageExecution execution = this.execution();
        this.localField.value(execution != null ? execution.content(LanguageExecution.Type.Local) : null);
        this.templateSelector.clear();
        this.templateSelector.addAll(Languages);
        this.templateSelector.selection(new String[]{Languages.getFirst()});
    }

    private void initRemoteEnvironmentBlock() {
        this.remoteField.onChange(e -> this.saveRemoteConfiguration((String)e.value()));
    }

    private void refreshRemoteEnvironmentBlock() {
        LanguageExecution execution = this.execution();
        this.remoteField.value(execution != null ? execution.content(LanguageExecution.Type.Remote) : null);
    }

    private void saveRemoteConfiguration(String content) {
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveExecution(this.language, this.release, LanguageExecution.Type.Remote, content, this.username());
        this.remoteField.error(this.errorMessage(content));
    }

    private void saveLocalConfiguration(String content) {
        ((EditorBox)this.box()).commands(LanguageCommands.class).saveExecution(this.language, this.release, LanguageExecution.Type.Local, content, this.username());
        this.localField.error(this.errorMessage(content));
    }

    private LanguageExecution execution() {
        LanguageRelease languageRelease = this.language.release(this.release);
        return languageRelease != null ? languageRelease.execution() : null;
    }

    private String errorMessage(String content) {
        String data;
        String string = data = content != null ? content.toLowerCase() : "";
        if (!data.contains("[model]")) {
            return this.translate("Invalid command. Make sure it includes both [model] and [release] placeholders.");
        }
        if (!data.contains("[release]")) {
            return this.translate("Invalid command. Make sure it includes both [model] and [release] placeholders.");
        }
        return null;
    }
}

