/*
 * Decompiled with CFR 0.152.
 */
package io.quassar.editor.box.ui.displays.templates;

import io.intino.alexandria.ui.server.UIFile;
import io.quassar.editor.box.EditorBox;
import io.quassar.editor.box.ui.displays.templates.AbstractDownloadModelDialog;
import io.quassar.editor.box.util.DisplayHelper;
import io.quassar.editor.box.util.ModelHelper;
import io.quassar.editor.box.util.PathHelper;
import io.quassar.editor.model.Model;
import java.io.File;

public class DownloadModelDialog
extends AbstractDownloadModelDialog<EditorBox> {
    private Model model;
    private String release;

    public DownloadModelDialog(EditorBox box) {
        super(box);
    }

    public void model(Model model) {
        this.model = model;
    }

    public void release(String release) {
        this.release = release;
    }

    public void open() {
        if (this.model.isPublic()) {
            this.dialog.open();
        } else {
            this.downloadSilently.launch();
        }
    }

    @Override
    public void init() {
        super.init();
        this.download.onExecute(e -> this.download());
        this.downloadSilently.onExecute(e -> this.download());
        this.dialog.onOpen(e -> this.refreshDialog());
    }

    private void refreshDialog() {
        this.dialog.title(this.translate("Download %s").formatted(ModelHelper.label(this.model, this.language(), (EditorBox)this.box())));
        this.modelUrl.value(PathHelper.downloadModelUrl(this.model, this.release, this.session()));
        this.copyModelUrl.text(PathHelper.downloadModelUrl(this.model, this.release, this.session()));
    }

    private UIFile download() {
        File release = ((EditorBox)this.box()).modelManager().release(this.model, this.release);
        return DisplayHelper.uiFile(ModelHelper.label(this.model, this.language(), (EditorBox)this.box()) + "-" + release.getName(), release);
    }
}

