/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.NodeLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class NodeCloner {
    private final List<Node> nodes;
    private final Node node;
    private final Graph model;
    private final Map<String, Node> cloneMap = new HashMap<String, Node>();
    private final NodeLoader loader = this.cloneMap::get;

    private NodeCloner(List<Node> nodes, Node node, Graph model) {
        this.nodes = nodes;
        this.node = node;
        this.model = model;
    }

    static void clone(List<Node> toClone, Node node, Graph model) {
        if (toClone.isEmpty()) {
            return;
        }
        new NodeCloner(toClone, node, model).execute();
    }

    private void execute() {
        this.model.loaders.add(this.loader);
        this.nodes.stream().map(toClone -> this.clone(this.node.id() + "." + toClone.name(), (Node)toClone, this.node)).forEach(this.node::add);
        this.nodes.forEach(this::copyVariables);
        this.model.loaders.remove(this.loader);
    }

    private void copyVariables(Node original) {
        this.copyVariables(original, this.cloneMap.get(original.id()));
        original.componentList().forEach(this::copyVariables);
    }

    private Node clone(String name, Node toClone, Node owner) {
        Node clone = new Node(name);
        clone.owner(owner);
        toClone.typeNames.forEach(n -> clone.addLayer(this.model.concept$((String)n)));
        clone.syncLayers();
        this.cloneComponents(toClone, clone, name);
        this.register(toClone, clone);
        return clone;
    }

    private void register(Node toClone, Node clone) {
        this.cloneMap.put(toClone.id, clone);
        this.model.register(clone);
    }

    private void cloneComponents(Node toClone, Node clone, String name) {
        toClone.layers.forEach(origin -> {
            Layer destination = this.getLayerFrom(clone, (Layer)origin);
            toClone.componentList().forEach(c -> destination.addNode$(this.clone(name + "." + c.name(), (Node)c, clone)));
        });
    }

    private void copyVariables(Node toClone, Node clone) {
        toClone.layers.forEach(origin -> {
            Layer destination = this.getLayerFrom(clone, (Layer)origin);
            origin.variables$().entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).forEach(e -> destination.set$((String)e.getKey(), (List)e.getValue()));
        });
    }

    private Layer getLayerFrom(Node clone, Layer origin) {
        return clone.layers.stream().filter(l -> l.getClass() == origin.getClass()).findFirst().get();
    }
}

