/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte.utils;

import io.intino.tara.magritte.utils.UTF8Control;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class I18n {
    private static String BUNDLE = "messages.";
    private List<String> levels = new ArrayList<String>();
    private Map<String, List<PropertyResourceBundle>> bundles = new HashMap<String, List<PropertyResourceBundle>>();

    public void register(String level) {
        this.levels.add(0, level);
    }

    public String message(String locale, String key, Object ... params) {
        if (!this.bundles.containsKey(locale)) {
            this.bundles.put(locale, this.collectBundles(locale));
        }
        return this.resolveMessage(locale, key, params);
    }

    public Map<String, String> wordsIn(String language) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.extractKeys(language, map);
        return map;
    }

    private List<PropertyResourceBundle> collectBundles(String locale) {
        return this.levels.stream().map(level -> {
            try {
                PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle(BUNDLE + level, new Locale(locale), new UTF8Control());
                return bundle.getLocale().toString().equals(locale) ? bundle : (PropertyResourceBundle)ResourceBundle.getBundle(BUNDLE + level, new Locale(""), new UTF8Control());
            }
            catch (MissingResourceException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String resolveMessage(String locale, String key, Object[] params) {
        for (PropertyResourceBundle bundle : this.bundles.get(locale)) {
            try {
                return MessageFormat.format(new String(bundle.getString(key).getBytes(), StandardCharsets.UTF_8), params);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        Logger.getGlobal().warning("Message key not found: " + key);
        return key;
    }

    private void extractKeys(String language, Map<String, String> map) {
        for (PropertyResourceBundle bundle : this.bundles.get(language)) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                map.put(key, bundle.getString(key));
            }
        }
    }
}

