/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.ClassFinder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class LayerFactory {
    private final LayerMap layerMap;

    LayerFactory() {
        this.layerMap = new LayerMap();
    }

    LayerFactory(LayerFactory layerFactory) {
        this.layerMap = new LayerMap(layerFactory.layerMap);
    }

    private static Constructor<? extends Layer> getDeclaredConstructor(Class<? extends Layer> layerClass) {
        try {
            return layerClass.getDeclaredConstructor(Node.class);
        }
        catch (NoSuchMethodException e) {
            Logger.getGlobal().severe(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
            return null;
        }
    }

    Layer create(String name, Node node) {
        Class<? extends Layer> layerClass = this.layerMap.get(name);
        if (layerClass != null) {
            return this.create(layerClass, node);
        }
        Logger.getGlobal().severe("Concept " + name + " hasn't layer registered. Node " + node.id + " won't have it");
        return null;
    }

    Layer create(Class<? extends Layer> layerClass, Node node) {
        if (this.isAbstract(layerClass)) {
            return null;
        }
        try {
            Constructor<? extends Layer> constructor = this.layerMap.constructorOf(layerClass);
            constructor = constructor != null ? constructor : LayerFactory.getDeclaredConstructor(layerClass);
            return constructor.newInstance(node);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Logger.getGlobal().severe(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
            return null;
        }
    }

    private boolean isAbstract(Class<? extends Layer> layerClass) {
        return Modifier.isAbstract(layerClass.getModifiers());
    }

    List<String> names(Class<? extends Layer> layerClass) {
        List<String> list = this.layerMap.get(layerClass);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    void register(String name, String layerClass) {
        try {
            this.register(name, ClassFinder.find(layerClass));
        }
        catch (ClassNotFoundException e) {
            Logger.getGlobal().severe(e.getCause() == null ? e.getMessage() : e.getCause().getMessage());
        }
    }

    private void register(String name, Class<? extends Layer> layerClass) {
        this.layerMap.put(name, layerClass);
    }

    Class<? extends Layer> layerClass(String name) {
        return this.layerMap.get(name);
    }

    void clear() {
        this.layerMap.clear();
    }

    static class LayerMap {
        private final Map<String, Class<? extends Layer>> map;
        private final Map<Class<? extends Layer>, Constructor<? extends Layer>> methods;
        private final Map<Class<? extends Layer>, List<String>> names;

        LayerMap() {
            this.map = new HashMap<String, Class<? extends Layer>>();
            this.methods = new HashMap<Class<? extends Layer>, Constructor<? extends Layer>>();
            this.names = new HashMap<Class<? extends Layer>, List<String>>();
        }

        LayerMap(LayerMap layerMap) {
            this.map = new HashMap<String, Class<? extends Layer>>(layerMap.map);
            this.methods = new HashMap<Class<? extends Layer>, Constructor<? extends Layer>>(layerMap.methods);
            this.names = new HashMap<Class<? extends Layer>, List<String>>(layerMap.names);
        }

        void put(String name, Class<? extends Layer> layerClass) {
            this.map.put(name, layerClass);
            this.methods.put(layerClass, LayerFactory.getDeclaredConstructor(layerClass));
            if (!this.names.containsKey(layerClass)) {
                this.names.put(layerClass, new ArrayList());
            }
            this.names.get(layerClass).add(name);
        }

        public Class<? extends Layer> get(String name) {
            return this.map.get(name);
        }

        Constructor<? extends Layer> constructorOf(Class<? extends Layer> layerClass) {
            return this.methods.get(layerClass);
        }

        public List<String> get(Class<? extends Layer> layerClass) {
            return this.names.get(layerClass);
        }

        void clear() {
            this.map.clear();
            this.names.clear();
        }
    }
}

