/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.GraphCloner;
import io.intino.tara.magritte.GraphHelper;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.LayerFactory;
import io.intino.tara.magritte.M1;
import io.intino.tara.magritte.M2;
import io.intino.tara.magritte.M3;
import io.intino.tara.magritte.Model;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.NodeLoader;
import io.intino.tara.magritte.StashReader;
import io.intino.tara.magritte.Store;
import io.intino.tara.magritte.stores.ResourcesStore;
import io.intino.tara.magritte.utils.I18n;
import io.intino.tara.magritte.utils.StashHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Graph {
    Model model;
    Store store;
    Map<Node, Map<String, List<?>>> variables = new HashMap();
    Map<String, Node> nodes = new HashMap<String, Node>();
    Map<String, Concept> concepts = new HashMap<String, Concept>();
    Map<Class<? extends GraphWrapper>, GraphWrapper> wrappers = new HashMap<Class<? extends GraphWrapper>, GraphWrapper>();
    List<NodeLoader> loaders = new ArrayList<NodeLoader>();
    I18n i18n = new I18n();
    LayerFactory layerFactory = new LayerFactory();
    Set<String> languages = new LinkedHashSet<String>();
    Set<String> openedStashes = new HashSet<String>();

    public Graph() {
        this(new ResourcesStore());
    }

    public Graph(Store store) {
        this.store = store;
        this.model = new Model(this, this.wrappers);
    }

    public Graph loadStashes(String ... stashes) {
        if (stashes.length == 0) {
            return this;
        }
        this.doLoadStashes(stashes);
        return this;
    }

    public Graph loadStashes(Stash ... stashes) {
        this.doLoadStashes(stashes);
        return this;
    }

    public Node load(String id) {
        return this.load(id, true);
    }

    public Node load(String id, boolean logFail) {
        Node node = this.loadFromLoaders(id);
        if (node == null) {
            node = this.nodes.get(id);
        }
        if (node == null) {
            node = this.loadFromStash(id, logFail);
        }
        if (node == null && logFail) {
            Logger.getGlobal().warning("A reference to a node named as " + id + " has not been found");
        }
        return node;
    }

    public List<String> languages() {
        return Collections.unmodifiableList(new ArrayList<String>(this.languages));
    }

    public I18n i18n() {
        return this.i18n;
    }

    public URL loadResource(String path) {
        URL url = this.store.resourceFrom(path);
        if (url == null) {
            Logger.getGlobal().severe("Resource at " + path + " not found");
        }
        return url;
    }

    public Set<String> openedStashes() {
        return this.openedStashes;
    }

    public Store store() {
        return this.store;
    }

    void save(Node node) {
        this.save(node.stash());
    }

    public synchronized void save(String ... stashes) {
        if (!this.store.allowWriting()) {
            return;
        }
        GraphHelper.saveStashes(this, stashes);
    }

    public synchronized void saveAll(String ... excludedStashes) {
        if (!this.store.allowWriting()) {
            return;
        }
        GraphHelper.saveAll(this, excludedStashes);
    }

    public synchronized URL save(URL url, String path, URL oldUrl, Node node) {
        try {
            return this.store.writeResource(url.openConnection().getInputStream(), path, oldUrl, node);
        }
        catch (IOException e) {
            Logger.getGlobal().severe("Url at " + url.toString() + " could not be accessed");
            return null;
        }
    }

    public synchronized URL save(InputStream inputStream, String path, URL oldUrl, Node node) {
        return this.store.writeResource(inputStream, path, oldUrl, node);
    }

    public <T extends GraphWrapper> T as(Class<T> aClass) {
        if (!this.wrappers.containsKey(aClass)) {
            this.wrappers.put((Class<? extends GraphWrapper>)aClass, (GraphWrapper)GraphHelper.create(aClass, this));
        }
        return (T)this.wrappers.get(aClass);
    }

    public void remove(Node node) {
        node.owner().remove(node);
        this.nodes.remove(node.id);
        this.save(node.stash());
    }

    public void remove(String stash) {
        this.nodesIn(stash).forEach(node -> {
            node.owner().remove((Node)node);
            this.nodes.remove(node.id);
        });
        this.save(stash);
    }

    public void reload() {
        HashSet<String> openedStashes = new HashSet<String>(this.openedStashes);
        this.clear();
        openedStashes.forEach(s -> this.doLoadStashes(this.stashOf((String)s)));
        this.wrappers.values().forEach(GraphWrapper::update);
    }

    public void clear() {
        this.model.componentList().forEach(this.model::remove);
        this.openedStashes.clear();
        this.languages.clear();
        this.concepts.clear();
        this.nodes.clear();
        this.loaders.clear();
        this.wrappers.values().forEach(GraphWrapper::update);
        this.layerFactory.clear();
    }

    public Graph clone() {
        return GraphCloner.doClone(this, new Graph(this.store));
    }

    public <T extends Layer> T first(Class<T> aClass) {
        List<T> nodes = this.find(aClass);
        return (T)(nodes.isEmpty() ? null : (Layer)nodes.get(0));
    }

    public <T extends Layer> List<T> find(Class<T> aClass) {
        return this.model.findNode(aClass);
    }

    public M1 model() {
        return this.model.as(M1.class);
    }

    public M2 metamodel() {
        return this.model.as(M2.class);
    }

    public M3 metametamodel() {
        return this.model.as(M3.class);
    }

    public M1 m1() {
        return this.model.as(M1.class);
    }

    public M2 m2() {
        return this.model.as(M2.class);
    }

    public M3 m3() {
        return this.model.as(M3.class);
    }

    public List<Node> rootList() {
        return Collections.unmodifiableList(this.model.componentList());
    }

    public List<Node> rootList(Predicate<Node> predicate) {
        return Collections.unmodifiableList(this.model.componentList().stream().filter(predicate).collect(Collectors.toList()));
    }

    public <T extends Layer> List<T> rootList(Class<T> layerClass) {
        return this.model.componentList(layerClass);
    }

    public List<Concept> conceptList() {
        return Collections.unmodifiableList(new ArrayList<Concept>(this.concepts.values()));
    }

    public Stream<Concept> conceptList(Predicate<Concept> predicate) {
        return this.concepts.values().stream().filter(predicate);
    }

    public Concept concept(String name) {
        return this.concepts.get(name);
    }

    public Concept concept(Class<? extends Layer> layerClass) {
        return this.concepts.get(this.layerFactory.names(layerClass).get(0));
    }

    public <T extends Layer> T createRoot(Class<T> layerClass) {
        return this.createRoot(layerClass, "Misc", this.createNodeName());
    }

    public Node createRoot(Concept concept, String stash) {
        return this.createRoot(concept, stash, this.createNodeName());
    }

    public <T extends Layer> T createRoot(Class<T> layerClass, String stash) {
        return this.createRoot(layerClass, stash, this.createNodeName());
    }

    public Node createRoot(String type, String stash) {
        return this.createRoot(this.concept(type), stash, this.createNodeName());
    }

    public <T extends Layer> T createRoot(Class<T> layerClass, String stash, String name) {
        Node node = this.createRoot(this.concept(layerClass), stash, name);
        return node != null ? (T)node.as(layerClass) : null;
    }

    public Node createRoot(String type, String stash, String name) {
        return this.createRoot(this.concept(type), stash, name);
    }

    public Node createRoot(Concept concept, String stash, String name) {
        Node newNode = GraphHelper.createNode(this, concept, stash, name);
        if (newNode != null) {
            this.commit(newNode);
        }
        return newNode;
    }

    private void doLoadStashes(String ... stashes) {
        this.doLoadStashes((Stash[])Arrays.stream(stashes).map(StashHelper::stashWithExtension).map(this::stashOf).toArray(Stash[]::new));
    }

    void doLoadStashes(Stash ... stashes) {
        if (stashes == null || stashes.length == 0) {
            return;
        }
        stashes = this.processUses(stashes);
        Arrays.stream(stashes).filter(Objects::nonNull).forEach(s -> this.init(s.language));
        if (stashes.length == 0) {
            return;
        }
        this.readStashes(stashes);
    }

    private void readStashes(Stash[] stashes) {
        StashReader stashReader = new StashReader(this);
        Stream.of(stashes).forEach(stashReader::read);
        LinkedHashMap clone = new LinkedHashMap(this.variables);
        clone.forEach((node, map) -> {
            map.forEach(node::load);
            this.variables.remove(node);
        });
    }

    private Stash[] processUses(Stash[] stashes) {
        List<Stash> stashList = Arrays.stream(stashes).filter(Objects::nonNull).collect(Collectors.toList());
        int stashListSize = 0;
        while (stashListSize != stashList.size()) {
            stashListSize = stashList.size();
            stashList.addAll(this.processUses(stashList));
        }
        return stashList.toArray(new Stash[stashList.size()]);
    }

    private List<Stash> processUses(List<Stash> stashList) {
        ArrayList<Stash> result = new ArrayList<Stash>();
        stashList.forEach(s -> s.uses.stream().map(this::stashOf).filter(Objects::nonNull).forEach(result::add));
        return result;
    }

    private List<Node> nodesIn(String stash) {
        return this.model.graph.rootList().stream().filter(i -> i.stash().equals(stash)).collect(Collectors.toList());
    }

    private Stash stashOf(String source) {
        return this.stashOf(source, true);
    }

    Stash stashOf(String source, boolean logFail) {
        if (this.openedStashes.contains(source = StashHelper.stashWithExtension(source))) {
            return null;
        }
        this.openedStashes.add(source);
        Stash stash = this.store.stashFrom(source);
        if (stash == null && logFail) {
            Logger.getGlobal().warning("Stash " + source + " does not exist or cannot be opened");
        }
        return stash;
    }

    String createNodeName() {
        return UUID.randomUUID().toString();
    }

    void addVariableIn(Node node, Map<String, List<?>> variables) {
        this.variables.put(node, variables);
    }

    Concept concept$(String name) {
        if (name == null) {
            return null;
        }
        if (!this.concepts.containsKey(name)) {
            this.register(new Concept(name));
        }
        return this.concepts.get(name);
    }

    Node node$(String name) {
        if (name == null) {
            name = this.createNodeName();
        }
        Node node = new Node(name);
        this.register(node);
        return node;
    }

    protected Node node(String name) {
        return this.nodes.get(name);
    }

    protected Node loadFromStash(String id) {
        return this.loadFromStash(id, true);
    }

    protected Node loadFromStash(String id, boolean logFail) {
        this.doLoadStashes(this.stashOf(StashHelper.stashWithExtension(id), logFail));
        return this.node(id);
    }

    void init(String language) {
        if (this.openedStashes.contains(StashHelper.stashWithExtension(language))) {
            this.languages.add(language);
            return;
        }
        if (this.languages.contains(language) || "Verso".equals(language) || "Proteo".equals(language)) {
            return;
        }
        if (language == null || language.isEmpty()) {
            return;
        }
        this.doInit(language);
    }

    private void doInit(String language) {
        this.languages.add(language);
        Stash stash = this.stashOf(language);
        this.doLoadStashes(stash);
    }

    private Node loadFromLoaders(String id) {
        NodeLoader loader;
        Node result = null;
        Iterator<NodeLoader> iterator = this.loaders.iterator();
        while (iterator.hasNext() && (result = (loader = iterator.next()).loadNode(id)) == null) {
        }
        return result;
    }

    private void register(Concept concept) {
        this.concepts.put(concept.id, concept);
    }

    void register(Node node) {
        this.nodes.put(node.id, node);
    }

    private void commit(Node node) {
        this.model.add(node);
        this.register(node);
        this.openedStashes.add(StashHelper.stashWithExtension(node.stash()));
    }
}

