/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.io.Stash;
import io.intino.tara.io.Variable;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphHandler;
import io.intino.tara.magritte.MagritteException;
import io.intino.tara.magritte.Model;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.NodeCloner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

class StashReader {
    private static List<String> proteoTypes = new ArrayList<String>(Arrays.asList("Concept", "MetaConcept", "Facet", "MetaFacet", "Facet#MetaConcept", "Facet#Concept", "Facet#Facet", "Facet#MetaFacet", "MetaFacet#MetaConcept", "MetaFacet#Concept", "MetaFacet#Facet", "MetaFacet#MetaFacet"));
    private final GraphHandler model;

    StashReader(GraphHandler model) {
        this.model = model;
    }

    void read(Stash stash) {
        this.loadConcepts(stash.concepts);
        this.loadNodes(this.model.model, stash.nodes);
    }

    private void loadConcepts(List<io.intino.tara.io.Concept> rawConcepts) {
        for (io.intino.tara.io.Concept rawConcept : rawConcepts) {
            this.model.layerFactory.register(rawConcept.name, rawConcept.className);
            this.loadConcept(this.model.$concept(rawConcept.name), rawConcept);
        }
    }

    private void loadConcept(Concept concept, io.intino.tara.io.Concept rawConcept) {
        concept.parent(this.model.$concept(rawConcept.parent));
        List<Concept> concepts = this.typesWithoutConcept(rawConcept);
        concept.metatype = !concepts.isEmpty() ? concepts.get(0) : null;
        concept.concepts(this.metaTypesOf(concepts));
        concept.isAbstract = rawConcept.isAbstract;
        concept.isMetaConcept = rawConcept.isMetaConcept;
        concept.isMain = rawConcept.isMain;
        concept.layerClass = this.model.layerFactory.layerClass(concept.id);
        concept.contentRules = rawConcept.contentRules.stream().map(c -> new Concept.Content(this.model.$concept(c.type), c.min, c.max)).collect(Collectors.toSet());
        concept.nodes = this.loadVirtualNodes(rawConcept.nodes);
        concept.parameters = rawConcept.parameters.stream().collect(Collectors.toMap(v -> v.name, v -> v.values, (oldK, newK) -> newK, LinkedHashMap::new));
        concept.variables = rawConcept.variables.stream().collect(Collectors.toMap(v -> v.name, v -> v.values, (oldK, newK) -> newK, LinkedHashMap::new));
    }

    private List<Concept> typesWithoutConcept(io.intino.tara.io.Concept taraConcept) {
        ArrayList<Concept> result = new ArrayList<Concept>();
        for (String type : taraConcept.types) {
            if (proteoTypes.contains(type)) continue;
            result.add(this.model.$concept(type));
        }
        return result;
    }

    private List<Node> loadNodes(Node parent, List<io.intino.tara.io.Node> rawNodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (io.intino.tara.io.Node rawNode : rawNodes) {
            Node node = this.model.$node(rawNode.name);
            node.owner(parent);
            this.loadNode(node, rawNode);
            parent.add(node);
            result.add(node);
        }
        return result;
    }

    private Node loadNode(Node node, io.intino.tara.io.Node rawNode) {
        List<Concept> metaTypes = this.metaTypesOf(this.conceptsOf(rawNode.facets));
        this.addConcepts(node, metaTypes);
        this.loadNodes(node, rawNode.nodes);
        this.cloneNodes(node);
        this.saveVariables(node, rawNode.variables, metaTypes);
        return node;
    }

    private List<Node> loadVirtualNodes(List<io.intino.tara.io.Node> nodes) {
        Model root = new Model();
        root.graph = (Graph)this.model;
        return this.loadNodes(root, nodes);
    }

    private void addConcepts(Node node, List<Concept> metaTypes) {
        node.addLayers(metaTypes);
        node.syncLayers();
    }

    private List<Concept> conceptsOf(List<String> facets) {
        ArrayList<Concept> result = new ArrayList<Concept>();
        for (String facet : facets) {
            Concept concept = this.model.concepts.get(facet);
            if (concept == null) {
                throw new MagritteException("Concept " + facet + " not found");
            }
            result.add(concept);
        }
        return result;
    }

    private void saveVariables(Node node, List<Variable> variables, List<Concept> types) {
        LinkedHashMap variableMap = new LinkedHashMap();
        types.forEach(c -> variableMap.putAll(c.variables));
        types.forEach(t -> variableMap.putAll(t.parameters));
        variables.forEach(e -> variableMap.put(e.name, e.values));
        this.model.addVariableIn(node, variableMap);
    }

    private void cloneNodes(Node node) {
        NodeCloner.clone(this.nodesOf(node), node, this.model);
    }

    private List<Node> nodesOf(Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (String typeName : node.typeNames) {
            nodes.addAll(this.model.concepts.get((Object)typeName).nodes);
        }
        return nodes;
    }

    private List<Concept> metaTypesOf(Collection<Concept> metaConcepts) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (Concept metaConcept : metaConcepts) {
            concepts.addAll(this.metaTypesOf(metaConcept.concepts));
            concepts.add(metaConcept);
        }
        return concepts;
    }
}

