/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Model;
import io.intino.tara.magritte.Predicate;
import io.intino.tara.magritte.utils.PathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Node
extends Predicate {
    final List<Layer> layers = new ArrayList<Layer>();
    private Node owner;

    public Node() {
        this("");
    }

    public Node(String name) {
        super(name);
    }

    @Override
    public List<Concept> conceptList() {
        ArrayList<Concept> result = new ArrayList<Concept>();
        Graph graph = this.graph();
        for (String typeName : this.typeNames) {
            result.add(graph.concept(typeName));
        }
        Collections.reverse(result);
        return result;
    }

    public Model model() {
        Node node = this;
        while (node.owner != null) {
            node = node.owner;
        }
        return (Model)node;
    }

    public Node root() {
        Node node = this;
        while (!(node.owner instanceof Model)) {
            node = node.owner;
        }
        return node;
    }

    public void add(Node node) {
        for (Layer layer : this.layers) {
            layer.addNode(node);
        }
    }

    @Override
    public Map<String, List<?>> variables() {
        HashMap variables = new HashMap();
        this.layers.forEach(m -> variables.putAll(m.variables()));
        return variables;
    }

    @Override
    public <T extends Layer> List<T> findNode(Class<T> layerClass) {
        ArrayList tList = new ArrayList();
        if (this.is(layerClass)) {
            tList.add(this.as(layerClass));
        }
        this.componentList().forEach(c -> tList.addAll(c.findNode(layerClass)));
        return tList;
    }

    protected void remove(Node node) {
        this.layers.forEach(l -> l.removeNode(node));
    }

    public void addLayers(List<Concept> concepts) {
        concepts.forEach(this::addLayer);
    }

    public Node addLayer(Concept concept) {
        if (this.is(concept.id)) {
            return this;
        }
        this.putType(concept);
        this.createLayer(concept);
        this.removeParentLayer(concept);
        return this;
    }

    public Node addLayer(Class<? extends Layer> layerClass) {
        this.createLayer(layerClass);
        return this;
    }

    public void removeLayers(List<Concept> concepts) {
        concepts.forEach(this::removeLayer);
    }

    public Node removeLayer(Concept concept) {
        if (!this.is(concept.id())) {
            return this;
        }
        this.deleteType(concept);
        this.deleteLayer(concept.layerClass());
        return this;
    }

    public Node removeLayer(Class<? extends Layer> layerClass) {
        this.deleteLayer(layerClass);
        return this;
    }

    public <T extends Layer> T as(Class<T> layerClass) {
        for (Layer layer : this.layers) {
            if (!layerClass.isAssignableFrom(layer.getClass())) continue;
            return (T)layer;
        }
        return null;
    }

    public Layer as(String conceptName) {
        return this.as(this.graph().layerFactory.layerClass(conceptName));
    }

    @Override
    public List<Node> componentList() {
        LinkedHashSet nodes = new LinkedHashSet();
        this.reverseListOf(this.layers).forEach(l -> nodes.addAll(l.componentList()));
        return new ArrayList<Node>(nodes);
    }

    public <T extends Layer> List<T> componentList(Class<T> layerClass) {
        List<String> types = this.graph().layerFactory.names(layerClass);
        return this.componentList().stream().filter(c -> c.isAnyOf(types)).map(c -> c.as(layerClass)).collect(Collectors.toList());
    }

    public void owner(Node owner) {
        this.owner = owner;
    }

    public Node owner() {
        return this.owner;
    }

    public <T extends Layer> T ownerAs(Class<T> layerClass) {
        if (this.owner == null) {
            return null;
        }
        if (this.owner.is(layerClass)) {
            return this.owner.as(layerClass);
        }
        return this.owner.ownerAs(layerClass);
    }

    void load(String varName, List<?> value) {
        this.layers.forEach(l -> l._load(varName, value));
    }

    public void load(Layer layer, String name, List<?> values) {
        if (layer.node() == this) {
            layer._load(name, values);
        } else {
            Logger.getGlobal().severe("Layer does not belong to node " + name);
        }
    }

    void set(String varName, List<?> value) {
        this.layers.forEach(l -> l._set(varName, value));
    }

    public void set(Layer layer, String name, List<?> values) {
        if (layer.node() == this) {
            layer._set(name, values);
        } else {
            Logger.getGlobal().severe("Layer does not belong to node " + name);
        }
    }

    public void save() {
        this.graph().save(this);
    }

    private void createLayer(Concept concept) {
        Layer layer = this.graph().layerFactory.create(concept.id, this);
        if (layer != null) {
            this.layers.add(0, layer);
        }
    }

    private void deleteLayer(Class<? extends Layer> layerClass) {
        this.layers.remove(this.as(layerClass));
    }

    private void createLayer(Class<? extends Layer> layerClass) {
        Layer layer = this.graph().layerFactory.create(layerClass, this);
        if (layer != null) {
            this.layers.add(0, layer);
        }
    }

    private void removeParentLayer(Concept concept) {
        if (concept.parent() == null || concept.parent().isAbstract()) {
            return;
        }
        Layer toRemove = null;
        for (Layer layer : this.layers) {
            if (layer.getClass() != concept.parent().layerClass) continue;
            toRemove = layer;
            break;
        }
        if (toRemove != null) {
            this.layers.remove(toRemove);
        }
    }

    public Graph graph() {
        return this.model().graph();
    }

    public String path() {
        return PathHelper.pathOf(this.id);
    }

    private <T> List<T> reverseListOf(List<T> list) {
        ArrayList<T> result = new ArrayList<T>(list);
        Collections.reverse(result);
        return result;
    }

    public void delete() {
        this.graph().remove(this);
    }

    public boolean is(String concept) {
        return this.typeNames.contains(concept);
    }

    public boolean is(Concept concept) {
        return this.typeNames.contains(concept.name());
    }

    public boolean is(Class<? extends Layer> layer) {
        return this.isAnyOf(this.concepts(layer));
    }

    private List<String> concepts(Class<? extends Layer> layerClass) {
        return this.graph().layerFactory.names(layerClass);
    }

    boolean isAnyOf(List<String> concepts) {
        return concepts.stream().anyMatch(this::is);
    }

    public Layer as(Concept concept) {
        return this.as(concept.id);
    }

    void syncLayers() {
        this.layers.forEach(l -> this.layers.forEach(l::_sync));
    }
}

