/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Node;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class Layer {
    private final Node node;

    public Layer(Node node) {
        this.node = node;
    }

    public String id() {
        return this.node.id();
    }

    public String name() {
        return this.node.name();
    }

    public Node node() {
        return this.node;
    }

    public boolean is(String concept) {
        return this.node.is(concept);
    }

    public boolean is(Class<? extends Layer> layerClass) {
        return this.node.is(layerClass);
    }

    public boolean is(Concept concept) {
        return this.node.is(concept.id());
    }

    public Node owner() {
        return this.node.owner();
    }

    public <T extends Layer> T ownerAs(Class<T> layerClass) {
        return this.node.ownerAs(layerClass);
    }

    protected void _sync(Layer layer) {
    }

    protected void _set(String name, List<?> object) {
    }

    protected void _load(String name, List<?> object) {
    }

    public Map<String, List<?>> variables() {
        return Collections.emptyMap();
    }

    public void createNode(String name, Concept concept) {
        this.node.add(concept.createNode(name, this.node));
    }

    public List<Node> componentList() {
        return Collections.emptyList();
    }

    public Graph graph() {
        return this.node().graph();
    }

    public void delete() {
        this.node().delete();
    }

    public void save() {
        this.node().save();
    }

    public <T extends Layer> T as(Class<T> layerClass) {
        return this.node.as(layerClass);
    }

    public <T extends Layer> T addFacet(Class<T> layerClass) {
        return (T)this.addFacet(this.graph().layerFactory.names(layerClass).get(0));
    }

    public Layer addFacet(String concept) {
        return this.addFacet(this.graph().concept(concept));
    }

    public Layer addFacet(Concept concept) {
        concept.createLayersFor(this.node);
        this.node.syncLayers();
        return this.node.as(concept);
    }

    public void removeFacet(Class<? extends Layer> layerClass) {
        this.removeFacet(this.graph().layerFactory.names(layerClass).get(0));
    }

    public void removeFacet(String concept) {
        this.removeFacet(this.graph().concept(concept));
    }

    public void removeFacet(Concept concept) {
        this.node.removeLayer(concept).as(concept);
    }

    protected void addNode(Node node) {
    }

    protected void removeNode(Node node) {
    }

    public String toString() {
        return this.node.id();
    }
}

