/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.LayerFactory;
import io.intino.tara.magritte.Model;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.NodeLoader;
import io.intino.tara.magritte.StashReader;
import io.intino.tara.magritte.StashWriter;
import io.intino.tara.magritte.Store;
import io.intino.tara.magritte.utils.I18n;
import io.intino.tara.magritte.utils.PathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class GraphHandler {
    final Store store;
    final Model model = new Model();
    private final Map<Node, Map<String, List<?>>> variables = new HashMap();
    protected Map<Class<? extends GraphWrapper>, GraphWrapper> wrappers = new HashMap<Class<? extends GraphWrapper>, GraphWrapper>();
    protected Map<String, Node> nodes = new HashMap<String, Node>();
    LayerFactory layerFactory = new LayerFactory();
    Set<String> openedStashes = new HashSet<String>();
    Set<String> languages = new LinkedHashSet<String>();
    Map<String, Concept> concepts = new HashMap<String, Concept>();
    List<NodeLoader> loaders = new ArrayList<NodeLoader>();
    private I18n i18n = new I18n();

    GraphHandler(Store store) {
        this.store = store;
    }

    protected static <T extends GraphWrapper> T create(Class<T> aClass, Graph graph) {
        try {
            GraphWrapper instance = (GraphWrapper)aClass.getConstructor(Graph.class).newInstance(graph);
            instance.update();
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> languages() {
        return Collections.unmodifiableList(new ArrayList<String>(this.languages));
    }

    protected void doLoadPath(String ... paths) {
        this.doLoadStashes((String[])Arrays.stream(paths).map(PathHelper::pathWithExtension).toArray(String[]::new));
    }

    protected void doLoadStashes(String ... paths) {
        this.doLoadStashes((Stash[])Arrays.stream(paths).map(this::stashOf).toArray(Stash[]::new));
    }

    protected void doLoadStashes(Stash ... stashes) {
        if (stashes == null || stashes.length == 0) {
            return;
        }
        stashes = this.processUses(stashes);
        Arrays.stream(stashes).filter(Objects::nonNull).forEach(s -> this.init(s.language));
        if (stashes.length == 0) {
            return;
        }
        this.readStashes(stashes);
    }

    private void readStashes(Stash[] stashes) {
        StashReader stashReader = new StashReader(this);
        Stream.of(stashes).forEach(stashReader::read);
        LinkedHashMap clone = new LinkedHashMap(this.variables);
        clone.forEach((node, map) -> {
            map.forEach(node::load);
            this.variables.remove(node);
        });
    }

    protected Stash[] processUses(Stash[] stashes) {
        List<Stash> stashList = Arrays.stream(stashes).filter(Objects::nonNull).collect(Collectors.toList());
        int stashListSize = 0;
        while (stashListSize != stashList.size()) {
            stashListSize = stashList.size();
            stashList.addAll(this.processUses(stashList));
        }
        return stashList.toArray(new Stash[stashList.size()]);
    }

    private List<Stash> processUses(List<Stash> stashList) {
        ArrayList<Stash> result = new ArrayList<Stash>();
        stashList.forEach(s -> s.uses.stream().map(this::stashOf).filter(Objects::nonNull).forEach(result::add));
        return result;
    }

    public Node loadNode(String id) {
        Node node = this.loadFromLoaders(id);
        if (node == null) {
            node = this.nodes.get(id);
        }
        if (node == null) {
            node = this.loadFromStash(id);
        }
        if (node == null) {
            Logger.getGlobal().warning("A reference to a node named as " + id + " has not been found");
        }
        return node;
    }

    public I18n i18n() {
        return this.i18n;
    }

    public URL loadResource(String path) {
        URL url = this.store.resourceFrom(path);
        if (url == null) {
            Logger.getGlobal().severe("Resource at " + path + " not found");
        }
        return url;
    }

    public Set<String> openedStashes() {
        return this.openedStashes;
    }

    protected abstract void registerRoot(Node var1);

    public Store store() {
        return this.store;
    }

    void save(Node node) {
        this.save(node.path());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String ... paths) {
        if (!this.store.allowWriting()) {
            return;
        }
        GraphHandler graphHandler = this;
        synchronized (graphHandler) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(paths));
            HashMap pathNodes = new HashMap();
            set.forEach(p -> {
                List cfr_ignored_0 = pathNodes.put(p, new ArrayList());
            });
            for (Node node : this.model.graph.rootList()) {
                if (!set.contains(node.path())) continue;
                ((List)pathNodes.get(node.path())).add(node);
            }
            for (Map.Entry entry : pathNodes.entrySet()) {
                StashWriter.write(this, PathHelper.pathWithExtension((String)entry.getKey()), (List)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(String ... excludedPaths) {
        if (!this.store.allowWriting()) {
            return;
        }
        GraphHandler graphHandler = this;
        synchronized (graphHandler) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(excludedPaths));
            HashMap pathNodes = new HashMap();
            for (Node node : this.model.graph.rootList()) {
                if (set.contains(node.path())) continue;
                if (!pathNodes.containsKey(node.path())) {
                    pathNodes.put(node.path(), new ArrayList());
                }
                ((List)pathNodes.get(node.path())).add(node);
            }
            for (Map.Entry entry : pathNodes.entrySet()) {
                StashWriter.write(this, PathHelper.pathWithExtension((String)entry.getKey()), (List)entry.getValue());
            }
        }
    }

    private List<Node> nodesIn(String path) {
        return this.model.graph.rootList().stream().filter(i -> i.path().equals(path)).collect(Collectors.toList());
    }

    public synchronized URL save(URL url, String path, URL oldUrl, Node node) {
        try {
            return this.store.writeResource(url.openConnection().getInputStream(), path, oldUrl, node);
        }
        catch (IOException e) {
            Logger.getGlobal().severe("Url at " + url.toString() + " could not be accessed");
            return null;
        }
    }

    public synchronized URL save(InputStream inputStream, String path, URL oldUrl, Node node) {
        return this.store.writeResource(inputStream, path, oldUrl, node);
    }

    Stash stashOf(String source) {
        if (this.openedStashes.contains(source = PathHelper.pathWithExtension(source))) {
            return null;
        }
        this.openedStashes.add(source);
        Stash stash = this.store.stashFrom(source);
        if (stash == null) {
            Logger.getGlobal().severe("Stash " + source + " does not exist or cannot be opened");
        }
        return stash;
    }

    String createNodeName() {
        return UUID.randomUUID().toString();
    }

    void addVariableIn(Node node, Map<String, List<?>> variables) {
        this.variables.put(node, variables);
    }

    Concept $concept(String name) {
        if (name == null) {
            return null;
        }
        if (!this.concepts.containsKey(name)) {
            this.register(new Concept(name));
        }
        return this.concepts.get(name);
    }

    Node $node(String name) {
        if (name == null) {
            name = this.createNodeName();
        }
        Node node = new Node(name);
        this.register(node);
        return node;
    }

    protected Node node(String name) {
        return this.nodes.get(name);
    }

    protected Node loadFromStash(String id) {
        this.doLoadStashes(this.stashOf(PathHelper.pathWithExtension(id)));
        return this.node(id);
    }

    void init(String language) {
        if (this.openedStashes.contains(PathHelper.pathWithExtension(language))) {
            this.languages.add(language);
            return;
        }
        if (this.languages.contains(language) || "Verso".equals(language) || "Proteo".equals(language)) {
            return;
        }
        if (language == null || language.isEmpty()) {
            return;
        }
        this.doInit(language);
    }

    private void doInit(String language) {
        this.languages.add(language);
        Stash stash = this.stashOf(language);
        if (stash == null) {
            Logger.getGlobal().severe("Language or model corrupt or not found: " + language);
        }
        this.doLoadStashes(stash);
    }

    private Node loadFromLoaders(String id) {
        NodeLoader loader;
        Node result = null;
        Iterator<NodeLoader> iterator = this.loaders.iterator();
        while (iterator.hasNext() && (result = (loader = iterator.next()).loadNode(id)) == null) {
        }
        return result;
    }

    private void register(Concept concept) {
        this.concepts.put(concept.id, concept);
    }

    void register(Node node) {
        this.nodes.put(node.id, node);
    }

    public <T extends GraphWrapper> T wrapper(Class<T> aClass) {
        return (T)this.wrappers.get(aClass);
    }

    public void remove(Node node) {
        node.owner().remove(node);
        this.nodes.remove(node.id);
        this.save(node.path());
    }

    public void remove(String path) {
        this.nodesIn(path).forEach(node -> {
            node.owner().remove((Node)node);
            this.nodes.remove(node.id);
        });
        this.save(path);
    }

    public void reload() {
        HashSet<String> openedStashes = new HashSet<String>(this.openedStashes);
        this.clear();
        openedStashes.forEach(s -> this.doLoadStashes(this.stashOf((String)s)));
        this.wrappers.values().forEach(GraphWrapper::update);
    }

    public void clear() {
        this.model.componentList().forEach(this.model::remove);
        this.openedStashes.clear();
        this.languages.clear();
        this.concepts.clear();
        this.nodes.clear();
        this.loaders.clear();
        this.wrappers.values().forEach(GraphWrapper::update);
        this.layerFactory.clear();
    }
}

