/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.GraphCloner;
import io.intino.tara.magritte.GraphHandler;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.M1;
import io.intino.tara.magritte.M2;
import io.intino.tara.magritte.M3;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.Store;
import io.intino.tara.magritte.stores.ResourcesStore;
import io.intino.tara.magritte.utils.PathHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Graph
extends GraphHandler {
    protected Graph(Store store) {
        super(store);
        this.model.graph = this;
        this.model.addLayer(M1.class);
        this.model.addLayer(M2.class);
        this.model.addLayer(M3.class);
        this.model.typeNames.add("Model");
    }

    @SafeVarargs
    public static Graph use(Store store, Class<? extends GraphWrapper> ... wrapperClasses) {
        Graph graph = new Graph(store);
        Arrays.stream(wrapperClasses).filter(Objects::nonNull).forEach(c -> {
            GraphWrapper cfr_ignored_0 = (GraphWrapper)graph.wrappers.put(c, Graph.create(c, graph));
        });
        return graph;
    }

    @SafeVarargs
    public static Graph use(Class<? extends GraphWrapper> ... wrapperClasses) {
        return Graph.use(new ResourcesStore(), wrapperClasses);
    }

    public Graph load(String ... paths) {
        if (paths.length == 0) {
            this.doLoadPath("Model");
        } else {
            this.doLoadPath(paths);
        }
        return this;
    }

    public Graph loadStashes(Stash ... stashes) {
        this.doLoadStashes(stashes);
        return this;
    }

    public Graph clone() {
        return GraphCloner.doClone(this, new Graph(this.store));
    }

    public <T extends Layer> T first(Class<T> aClass) {
        List<T> nodes = this.find(aClass);
        return (T)(nodes.isEmpty() ? null : (Layer)nodes.get(0));
    }

    public <T extends Layer> List<T> find(Class<T> aClass) {
        return this.model.findNode(aClass);
    }

    public M1 model() {
        return this.model.as(M1.class);
    }

    public M2 metamodel() {
        return this.model.as(M2.class);
    }

    public M3 metametamodel() {
        return this.model.as(M3.class);
    }

    public M1 m1() {
        return this.model.as(M1.class);
    }

    public M2 m2() {
        return this.model.as(M2.class);
    }

    public M3 m3() {
        return this.model.as(M3.class);
    }

    public List<Node> rootList() {
        return Collections.unmodifiableList(this.model.componentList());
    }

    public List<Node> rootList(Predicate<Node> predicate) {
        return Collections.unmodifiableList(this.model.componentList().stream().filter(predicate).collect(Collectors.toList()));
    }

    public <T extends Layer> List<T> rootList(Class<T> layerClass) {
        return this.model.componentList(layerClass);
    }

    public List<Concept> conceptList() {
        return Collections.unmodifiableList(new ArrayList(this.concepts.values()));
    }

    public List<Concept> conceptList(Predicate<Concept> predicate) {
        return this.concepts.values().stream().filter(predicate).collect(Collectors.toList());
    }

    public Concept concept(String name) {
        return (Concept)this.concepts.get(name);
    }

    public Concept concept(Class<? extends Layer> layerClass) {
        return (Concept)this.concepts.get(this.layerFactory.names(layerClass).get(0));
    }

    public <T extends Layer> T createRoot(Class<T> layerClass) {
        return this.createRoot(layerClass, "Misc", this.createNodeName());
    }

    public Node createRoot(Concept concept, String stash) {
        return this.createRoot(concept, stash, this.createNodeName());
    }

    public <T extends Layer> T createRoot(Class<T> layerClass, String path) {
        return this.createRoot(layerClass, path, this.createNodeName());
    }

    public Node createRoot(String type, String path) {
        return this.createRoot(this.concept(type), path, this.createNodeName());
    }

    public <T extends Layer> T createRoot(Class<T> layerClass, String path, String name) {
        Node node = this.createRoot(this.concept(layerClass), path, name);
        return node != null ? (T)node.as(layerClass) : null;
    }

    public Node createRoot(String type, String path, String name) {
        return this.createRoot(this.concept(type), path, name);
    }

    public Node createRoot(Concept concept, String path, String name) {
        Node newNode = this.createNode(concept, path, name);
        if (newNode != null) {
            this.commit(newNode);
        }
        return newNode;
    }

    private Node createNode(Concept concept, String path, String name) {
        if (!concept.isMain()) {
            Logger.getGlobal().severe("Concept " + concept.id() + " is not main. The node could not be created.");
            return null;
        }
        if (concept.isAbstract()) {
            Logger.getGlobal().severe("Concept " + concept.id() + " is abstract. The node could not be created.");
            return null;
        }
        path = path == null || path.isEmpty() ? "Misc" : path;
        Logger.getGlobal().setUseParentHandlers(false);
        this.load(PathHelper.pathWithExtension(path));
        Logger.getGlobal().setUseParentHandlers(true);
        if (name != null && this.nodes.containsKey(path + "#" + name)) {
            Logger.getGlobal().warning("Node with id " + path + "#" + name + " already exists");
            return null;
        }
        return concept.createNode(PathHelper.canonicalPath(path), name == null ? this.createNodeName() : name, this.model);
    }

    private void commit(Node node) {
        this.model.add(node);
        this.register(node);
        this.openedStashes.add(PathHelper.pathWithExtension(node.path()));
    }

    @Override
    protected void registerRoot(Node root) {
        this.model.add(root);
    }
}

