/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.NodeCloner;
import io.intino.tara.magritte.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Concept
extends Predicate {
    final Set<Concept> concepts = new LinkedHashSet<Concept>();
    private final Set<Concept> children = new LinkedHashSet<Concept>();
    private final Set<Concept> instances = new LinkedHashSet<Concept>();
    boolean isAbstract;
    boolean isMetaConcept;
    boolean isMain;
    Class<? extends Layer> layerClass;
    Concept metatype = null;
    Set<Content> contentRules = new LinkedHashSet<Content>();
    List<Node> nodes = new ArrayList<Node>();
    Map<String, List<?>> variables = new LinkedHashMap();
    Map<String, List<?>> parameters = new LinkedHashMap();
    private Concept parent;

    public Concept(String name) {
        super(name);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMetaConcept() {
        return this.isMetaConcept;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public Class<? extends Layer> layerClass() {
        return this.layerClass;
    }

    @Override
    public List<Concept> conceptList() {
        return Collections.unmodifiableList(new ArrayList<Concept>(this.concepts));
    }

    public Concept parent() {
        return this.parent;
    }

    void parent(Concept parent) {
        if (parent == null) {
            return;
        }
        this.parent = parent;
        this.putType(parent);
        parent.children.add(this);
    }

    public List<Concept> children() {
        return Collections.unmodifiableList(new ArrayList<Concept>(this.children));
    }

    void concepts(List<Concept> concepts) {
        concepts.forEach(this::putType);
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    @Override
    protected void putType(Concept concept) {
        if (this.is(concept.id())) {
            return;
        }
        super.putType(concept);
        this.concepts.add(concept);
        concept.instances.add(this);
    }

    public List<Concept> instanceList() {
        LinkedHashSet<Concept> instances = new LinkedHashSet<Concept>();
        instances.addAll(this.instances);
        this.instances.forEach(s -> instances.addAll(s.instanceList()));
        return new ArrayList<Concept>(instances);
    }

    public List<Concept> multipleAllowed() {
        return Collections.unmodifiableList(this.contentRules.stream().filter(c -> c.max > 1).map(c -> c.concept).collect(Collectors.toList()));
    }

    public List<Concept> singleAllowed() {
        return Collections.unmodifiableList(this.contentRules.stream().filter(c -> c.max == 1).map(c -> c.concept).collect(Collectors.toList()));
    }

    public List<Concept> multipleRequired() {
        return Collections.unmodifiableList(this.contentRules.stream().filter(c -> c.min == 1 && c.max > 1).map(c -> c.concept).collect(Collectors.toList()));
    }

    public List<Concept> singleRequired() {
        return Collections.unmodifiableList(this.contentRules.stream().filter(c -> c.min == 1 && c.max == 1).map(c -> c.concept).collect(Collectors.toList()));
    }

    @Override
    public Map<String, List<?>> variables() {
        return Collections.unmodifiableMap(this.variables);
    }

    @Override
    public <T extends Layer> List<T> findNode(Class<T> aClass) {
        return null;
    }

    public Map<String, List<?>> parameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public List<Node> componentList() {
        return Collections.unmodifiableList(this.nodes);
    }

    Node createNode(String path, String name, Node owner) {
        if (this.isMetaConcept) {
            Logger.getGlobal().severe("Node cannot be created. Concept " + this.id + " is a MetaConcept");
            return null;
        }
        return this.newNode(path + "#" + (name != null ? name : owner.graph().createNodeName()), owner);
    }

    public Node createNode(Node owner) {
        return this.createNode(owner.graph().createNodeName(), owner);
    }

    public Node createNode(String name, Node owner) {
        if (this.isMetaConcept) {
            Logger.getGlobal().severe("Node cannot be created. Concept " + this.id + " is a MetaConcept");
            return null;
        }
        return this.newNode(owner.path() + "#" + (name != null ? name : owner.graph().createNodeName()), owner);
    }

    private Node newNode(String name, Node owner) {
        Node node = owner.graph().$node(name);
        node.owner(owner);
        this.createLayersFor(node);
        if (!owner.is("Model")) {
            owner.add(node);
        }
        return node;
    }

    void createLayersFor(Node node) {
        this.conceptList().forEach(node::addLayer);
        node.addLayer(this);
        node.syncLayers();
        this.cloneNodes(node);
        this.fillVariables(node.as(this));
        this.fillParameters(node.as(this));
    }

    private void cloneNodes(Node node) {
        this.conceptList().forEach(t -> t.cloneNodes(node));
        NodeCloner.clone(this.componentList(), node, node.graph());
    }

    private void fillVariables(Layer layer) {
        this.conceptList().forEach(c -> c.fillVariables(layer));
        this.variables.forEach(layer::_load);
    }

    private void fillParameters(Layer layer) {
        this.conceptList().forEach(c -> c.fillParameters(layer));
        this.parameters.forEach(layer::_load);
    }

    public String toString() {
        return this.id + "{names=" + this.concepts.stream().map(m -> m.id).collect(Collectors.toList()) + '}';
    }

    public boolean is(String concept) {
        return this.typeNames.contains(concept);
    }

    static class Content {
        Concept concept;
        int min;
        int max;

        Content(Concept concept, int min, int max) {
            this.concept = concept;
            this.min = min;
            this.max = max;
        }
    }
}

