/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints.component;

import io.intino.tara.Resolver;
import io.intino.tara.lang.model.Aspect;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.rules.NodeRule;
import io.intino.tara.lang.model.rules.Size;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import io.intino.tara.lang.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Component
implements Constraint.Component {
    private final String type;
    private final List<Rule> rules;
    private final List<Tag> annotations;

    public Component(String type, List<Rule> rules, List<Tag> annotations) {
        this.type = type;
        this.rules = rules;
        this.annotations = annotations;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public NodeRule compositionRule() {
        return this.rules.stream().filter(r -> r instanceof NodeRule).findFirst().orElse(null);
    }

    @Override
    public List<Rule> rules() {
        return this.rules;
    }

    @Override
    public List<Tag> annotations() {
        return this.annotations;
    }

    @Override
    public void check(Element element) throws SemanticException {
        List<Node> notAccepted;
        Node container = (Node)element;
        if (container.isReference()) {
            return;
        }
        List<Node> components = this.filterByType(container);
        List<Node> accepted = this.acceptedComponents(components);
        if (!accepted.isEmpty()) {
            components.forEach(this::addFlags);
        }
        if (!(notAccepted = this.notAccepted(components, accepted)).isEmpty()) {
            this.error(notAccepted.get(0));
        } else {
            this.checkRequired(element, accepted);
        }
    }

    private List<Node> acceptedComponents(List<Node> components) {
        return components.stream().filter(component -> this.rules.stream().allMatch(r -> this.accept((Rule)r, components, (Node)component))).collect(Collectors.toList());
    }

    private boolean accept(Rule r, List<Node> components, Node component) {
        return r instanceof Size ? r.accept(components) : r.accept(component);
    }

    private List<Node> notAccepted(List<Node> components, List<Node> accepted) {
        return components.stream().filter(c -> !accepted.contains(c)).collect(Collectors.toList());
    }

    private void error(Node notAccepted) throws SemanticException {
        for (Rule rule : this.rules) {
            if (this.accept(rule, notAccepted.container().components(), notAccepted)) continue;
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, rule.errorMessage(), notAccepted, rule.errorParameters()));
        }
    }

    private void checkRequired(Element element, List<Node> accepted) throws SemanticException {
        if (this.rules.get(0) instanceof Size && ((Size)this.rules.get(0)).isRequired() && !this.isAccepted(accepted, this.type())) {
            String message = "required.type.in.context";
            List<String> parameters = Collections.singletonList(this.type.replace(":", " on "));
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, element, parameters));
        }
    }

    private boolean isAccepted(List<Node> accepted, String type) {
        for (Node node : accepted) {
            if (!node.type().equals(type)) continue;
            return true;
        }
        return false;
    }

    private void addFlags(Node node) {
        ArrayList<Tag> flags = new ArrayList<Tag>(node.flags());
        for (Tag flag : this.annotations) {
            if (!flags.contains((Object)flag)) {
                node.addFlags(flag);
            }
            flags.add(flag);
        }
    }

    private List<Node> filterByType(NodeContainer node) {
        return node.components().stream().filter(this::isCompatibles).collect(Collectors.toList());
    }

    private boolean isCompatibles(Node node) {
        for (String nodeType : node.types()) {
            if (nodeType == null || !nodeType.equals(this.type) && !nodeType.equals(Resolver.shortType(this.type))) continue;
            return true;
        }
        return this.checkFacets(node);
    }

    private boolean checkFacets(Node node) {
        for (Aspect aspect : node.appliedAspects()) {
            if (!aspect.type().equals(Resolver.shortType(this.type))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Component{" + this.type + '}';
    }
}

