/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints;

import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import io.intino.tara.lang.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.List;

class MetaAspectConstraint
implements Constraint.MetaAspect {
    private final String type;
    private final String[] with;

    MetaAspectConstraint(String type, String[] with) {
        this.type = type;
        this.with = with;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String[] with() {
        return this.with;
    }

    @Override
    public void check(Element element) throws SemanticException {
        Node node = (Node)element;
        if (!this.is(node.types())) {
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.aspect.with.no.constrains.in.context", node, Arrays.asList(this.with)));
        }
    }

    private boolean is(List<String> nodeTypes) {
        if (this.with == null) {
            return true;
        }
        for (String aType : this.with) {
            if (nodeTypes.contains(aType)) continue;
            return false;
        }
        return true;
    }
}

