/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints.parameter;

import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import java.util.List;

abstract class ParameterConstraint
implements Constraint.Parameter {
    protected ParameterError error = ParameterError.TYPE;

    ParameterConstraint() {
    }

    static Parameter findParameter(List<Parameter> parameters, String facet, String name, int position) {
        for (Parameter parameter : parameters) {
            if (parameter.name().isEmpty() || !parameter.name().equals(name)) continue;
            return parameter;
        }
        Parameter parameter = ParameterConstraint.byPosition(parameters, facet, position);
        if (parameter != null) {
            return parameter;
        }
        return null;
    }

    private static Parameter byPosition(List<Parameter> parameters, String facet, int position) {
        for (Parameter parameter : parameters) {
            if (!parameter.name().isEmpty() || !parameter.facet().equals(facet) || parameter.position() != position) continue;
            return parameter;
        }
        return null;
    }

    boolean isNotAbstractNode(Element element) {
        return element instanceof Node && !((Node)element).isAbstract() && !this.isInherited((Node)element);
    }

    private boolean isInherited(Node node) {
        Node parent = node.parent();
        while (parent != null) {
            Parameter parameter = ParameterConstraint.findParameter(node.parent().parameters(), "", this.name(), this.position());
            if (parameter != null) {
                return true;
            }
            parent = node.parent();
        }
        return false;
    }

    protected abstract void error(Element var1, Parameter var2, ParameterError var3) throws SemanticException;

    static enum ParameterError {
        TYPE,
        NOT_FOUND,
        RECOVERABLE_ERROR,
        RULE,
        SIZE;

    }
}

