/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints;

import io.intino.tara.Resolver;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.Facet;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.NodeContainer;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Parametrized;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.Variable;
import io.intino.tara.lang.model.rules.Size;
import io.intino.tara.lang.model.rules.variable.VariableRule;
import io.intino.tara.lang.semantics.Assumption;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.constraints.FacetConstraint;
import io.intino.tara.lang.semantics.constraints.MetaFacetConstraint;
import io.intino.tara.lang.semantics.constraints.component.Component;
import io.intino.tara.lang.semantics.constraints.component.OneOf;
import io.intino.tara.lang.semantics.constraints.parameter.PrimitiveParameter;
import io.intino.tara.lang.semantics.constraints.parameter.ReferenceParameter;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import io.intino.tara.lang.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RuleFactory {
    private RuleFactory() {
    }

    public static Constraint.Component component(String type, List<Rule> rules, Tag ... flags) {
        return new Component(type, rules, Arrays.asList(flags));
    }

    @Deprecated
    public static Constraint.Component component(String type, Rule rule, Tag ... flags) {
        return new Component(type, Collections.singletonList(rule), Arrays.asList(flags));
    }

    public static Constraint.OneOf oneOf(List<Rule> rules, Constraint.Component ... components) {
        return new OneOf(Arrays.asList(components), rules);
    }

    public static Constraint.Parameter parameter(String name, Primitive type, String facet, Size size, int position, String scope, VariableRule rule, Tag ... tags) {
        return new PrimitiveParameter(name, type, facet, size, position, scope, rule, Arrays.asList(tags));
    }

    public static Constraint.Parameter parameter(String name, String type, String facet, Size size, int position, String scope, VariableRule rule, Tag ... tags) {
        return new ReferenceParameter(name, type, facet, size, position, scope, rule, Arrays.asList(tags));
    }

    public static Constraint.Facet facet(String type, boolean terminal, String[] with, String[] without) {
        return new FacetConstraint(type, terminal, with, without);
    }

    public static Constraint.MetaFacet metaFacet(String type, String ... with) {
        return new MetaFacetConstraint(type, with);
    }

    public static Constraint.ComponentNotFound rejectOtherComponents(final List<String> types) {
        return new Constraint.ComponentNotFound(){

            @Override
            public void check(Element element) throws SemanticException {
                NodeContainer node = (NodeContainer)element;
                for (Node component : node.components()) {
                    if (RuleFactory.areCompatibles(component, types)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.type.not.exists", component, Collections.singletonList(component.type().replace(":", ""))));
                }
            }
        };
    }

    private static boolean areCompatibles(Node component, List<String> allowedTypes) {
        for (String componentType : component.types()) {
            if (componentType == null || !allowedTypes.contains(componentType) && (component.container() == null || !RuleFactory.fromFacet(component.container().facets(), componentType, allowedTypes))) continue;
            return true;
        }
        return RuleFactory.checkFacets(component, allowedTypes);
    }

    public static Constraint.RejectOtherParameters rejectOtherParameters(final List<Constraint.Parameter> parameters) {
        return new Constraint.RejectOtherParameters(){

            @Override
            public void check(Element element) throws SemanticException {
                Parametrized parametrized = (Parametrized)((Object)element);
                for (Parameter parameter : parametrized.parameters()) {
                    if (this.isAcceptable(parameter, parameters)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.other.parameter.in.context", parameter, Collections.singletonList(parameter.name())));
                }
            }

            private boolean isAcceptable(Parameter parameter, List<Constraint.Parameter> parameters2) {
                for (Constraint.Parameter constraint : parameters2) {
                    if (!constraint.name().equals(parameter.name()) || !this.hasFacet(constraint.facet(), parameter.container().facets())) continue;
                    return true;
                }
                return false;
            }

            private boolean hasFacet(String requiredFacet, List<Facet> facets) {
                if (requiredFacet.isEmpty()) {
                    return true;
                }
                for (Facet facet : facets) {
                    if (!facet.type().equals(requiredFacet)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Constraint.RejectOtherParameters rejectOtherFacets(final List<Constraint.Facet> facets) {
        return new Constraint.RejectOtherParameters(){

            @Override
            public void check(Element element) throws SemanticException {
                Node node = (Node)element;
                for (Facet facet : node.facets()) {
                    if (this.isAcceptable(facets, facet)) continue;
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.other.facet.in.context", facet, Collections.singletonList(facet.type())));
                }
            }

            private boolean isAcceptable(List<Constraint.Facet> facets2, Facet facet) {
                for (Constraint.Facet constraint : facets2) {
                    if (!constraint.type().equals(facet.type())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static boolean fromFacet(List<Facet> facets, String nodeType, List<String> types) {
        return RuleFactory.facetComponent(facets, nodeType, types) || RuleFactory.asFacet(facets, nodeType.split(":")[0]);
    }

    private static boolean facetComponent(List<Facet> facets, String nodeType, List<String> types) {
        return facets.stream().anyMatch(facet -> types.contains(facet.type() + "+" + nodeType));
    }

    private static boolean asFacet(List<Facet> facets, String facet) {
        for (Facet f : facets) {
            if (!f.type().equals(facet)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkFacets(Node node, List<String> types) {
        List shortTypes = types.stream().map(Resolver::shortType).collect(Collectors.toList());
        for (Facet facet : node.facets()) {
            if (!shortTypes.contains(facet.type())) continue;
            return true;
        }
        return false;
    }

    public static Constraint name() {
        return new Constraint.Name(){

            @Override
            public void check(Element element) throws SemanticException {
                Node node = (Node)element;
                if (!node.isReference() && node.name().isEmpty()) {
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "required.name", element, Collections.emptyList()));
                }
            }
        };
    }

    public static Constraint.TerminalVariableRedefinition redefine(final String name, final String superType) {
        return new Constraint.TerminalVariableRedefinition(){

            @Override
            public void check(Element element) throws SemanticException {
                Node node = (Node)element;
                if (!node.flags().contains((Object)Tag.Instance)) {
                    for (Variable variable : node.variables()) {
                        if (!name.equals(variable.name())) continue;
                        return;
                    }
                    throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "required.terminal.variable.redefine", node, Arrays.asList(name, superType)));
                }
            }
        };
    }

    public static Assumption isFacet() {
        return new Assumption.Facet(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.Facet)) {
                    node.addFlag(Tag.Facet);
                }
                if (!node.flags().contains((Object)Tag.Terminal)) {
                    node.addFlag(Tag.Terminal);
                }
            }
        };
    }

    public static Assumption isFacetInstance() {
        return new Assumption.FacetInstance(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.FacetInstance)) {
                    node.addFlag(Tag.FacetInstance);
                }
            }
        };
    }

    public static Assumption isFeature() {
        return new Assumption.Feature(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.Feature)) {
                    node.addFlag(Tag.Feature);
                }
                RuleFactory.propagateFlags(node, Tag.Feature);
            }
        };
    }

    public static Assumption isTerminal() {
        return new Assumption.Terminal(){

            @Override
            public void assume(Node node) {
                if (node.isReference()) {
                    return;
                }
                if (!node.flags().contains((Object)Tag.Terminal)) {
                    node.addFlag(Tag.Terminal);
                }
                node.variables().stream().filter(variable -> !variable.flags().contains((Object)Tag.Terminal)).forEach(variable -> variable.addFlags(Tag.Terminal));
                RuleFactory.propagateFlags(node, Tag.Terminal);
            }
        };
    }

    public static Assumption isVolatile() {
        return new Assumption.Volatile(){

            @Override
            public void assume(Node node) {
                if (node.isReference()) {
                    return;
                }
                if (!node.flags().contains((Object)Tag.Volatile)) {
                    node.addFlag(Tag.Volatile);
                }
                RuleFactory.propagateFlags(node, Tag.Volatile);
            }
        };
    }

    public static Assumption isComponent() {
        return new Assumption.Component(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.Component)) {
                    node.addFlag(Tag.Component);
                }
            }
        };
    }

    public static Assumption isInstance() {
        return new Assumption.Instance(){

            @Override
            public void assume(Node node) {
                if (!node.flags().contains((Object)Tag.Instance)) {
                    node.addFlag(Tag.Instance);
                }
                node.variables().stream().filter(variable -> !variable.flags().contains((Object)Tag.Instance)).forEach(variable -> variable.addFlags(Tag.Instance));
                RuleFactory.propagateFlags(node, Tag.Instance);
            }
        };
    }

    private static void propagateFlags(Node node, Tag flag) {
        for (Node component : node.components()) {
            if (component.isReference()) continue;
            if (!component.flags().contains((Object)flag)) {
                component.addFlag(flag);
            }
            if (component.equals(node)) continue;
            RuleFactory.propagateFlags(component, flag);
        }
    }
}

