/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints;

import io.intino.tara.Resolver;
import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.FacetTarget;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.semantics.Constraint;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import io.intino.tara.lang.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.List;

class MetaFacetConstraint
implements Constraint.MetaFacet {
    private final String type;
    private final String[] with;

    MetaFacetConstraint(String type, String[] with) {
        this.type = type;
        this.with = with;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String[] with() {
        return this.with;
    }

    @Override
    public void check(Element element) throws SemanticException {
        Node node = (Node)element;
        FacetTarget facet = this.facetTarget(node);
        if (facet == null && !"any".equals(this.type())) {
            return;
        }
        if (!this.is(node.types())) {
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.facet.with.no.constrains.in.context", facet, Arrays.asList(this.with)));
        }
    }

    private FacetTarget facetTarget(Node node) {
        return node.facetTarget() != null && this.type.equals(Resolver.shortType(node.facetTarget().target())) ? node.facetTarget() : null;
    }

    private boolean is(List<String> nodeTypes) {
        if (this.with == null) {
            return true;
        }
        for (String aType : this.with) {
            if (nodeTypes.contains(aType)) continue;
            return false;
        }
        return true;
    }
}

